/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;

public final class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private transient int hashCode;
    private final T maximum;
    private final T minimum;
    private transient String toString;

    /*
     * Enabled aggressive block sorting
     */
    private Range(T t2, T t3, Comparator<T> comparableComparator) {
        if (t2 == null || t3 == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: element1=" + t2 + ", element2=" + t3);
        }
        if (comparableComparator == null) {
            comparableComparator = ComparableComparator.INSTANCE;
        }
        if (comparableComparator.compare(t2, t3) < 1) {
            this.minimum = t2;
            this.maximum = t3;
        } else {
            this.minimum = t3;
            this.maximum = t2;
        }
        this.comparator = comparableComparator;
    }

    public static <T extends Comparable<T>> Range<T> between(T t2, T t3) {
        return Range.between(t2, t3, null);
    }

    public static <T> Range<T> between(T t2, T t3, Comparator<T> comparator) {
        return new Range<T>(t2, t3, comparator);
    }

    public static <T extends Comparable<T>> Range<T> is(T t2) {
        return Range.between(t2, t2, null);
    }

    public static <T> Range<T> is(T t2, Comparator<T> comparator) {
        return Range.between(t2, t2, comparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(T t2) {
        int n2 = 1;
        if (t2 == null) {
            return false;
        }
        if (this.comparator.compare(t2, this.minimum) <= -1) return 0 != 0;
        if (this.comparator.compare(t2, this.maximum) >= n2) return 0 != 0;
        return n2 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean containsRange(Range<T> range) {
        return range != null && this.contains(range.minimum) && this.contains(range.maximum);
    }

    public int elementCompareTo(T t2) {
        if (t2 == null) {
            throw new NullPointerException("Element is null");
        }
        if (this.isAfter(t2)) {
            return -1;
        }
        if (this.isBefore(t2)) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (object == null || object.getClass() != this.getClass()) {
                    return false;
                }
                Range range = (Range)object;
                if (!this.minimum.equals(range.minimum) || !this.maximum.equals(range.maximum)) break block5;
            }
            return true;
        }
        return false;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public int hashCode() {
        int n2 = this.hashCode;
        if (this.hashCode == 0) {
            this.hashCode = n2 = 37 * (37 * (629 + this.getClass().hashCode()) + this.minimum.hashCode()) + this.maximum.hashCode();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Range<T> intersectionWith(Range<T> range) {
        T t2;
        if (!this.isOverlappedBy(range)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", range));
        }
        if (this.equals(range)) {
            return this;
        }
        T t3 = this.getComparator().compare(this.minimum, range.minimum) < 0 ? range.minimum : this.minimum;
        if (this.getComparator().compare(this.maximum, range.maximum) < 0) {
            t2 = this.maximum;
            return Range.between(t3, t2, this.getComparator());
        }
        t2 = range.maximum;
        return Range.between(t3, t2, this.getComparator());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isAfter(T t2) {
        return t2 != null && this.comparator.compare(t2, this.minimum) < 0;
    }

    public boolean isAfterRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isAfter(range.maximum);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isBefore(T t2) {
        return t2 != null && this.comparator.compare(t2, this.maximum) > 0;
    }

    public boolean isBeforeRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isBefore(range.minimum);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isEndedBy(T t2) {
        return t2 != null && this.comparator.compare(t2, this.maximum) == 0;
    }

    public boolean isNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isOverlappedBy(Range<T> range) {
        return range != null && (range.contains(this.minimum) || range.contains(this.maximum) || this.contains(range.minimum));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isStartedBy(T t2) {
        return t2 != null && this.comparator.compare(t2, this.minimum) == 0;
    }

    public String toString() {
        String string2 = this.toString;
        if (string2 == null) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append('[');
            stringBuilder.append(this.minimum);
            stringBuilder.append("..");
            stringBuilder.append(this.maximum);
            stringBuilder.append(']');
            this.toString = string2 = stringBuilder.toString();
        }
        return string2;
    }

    public String toString(String string2) {
        Object[] objectArray = new Object[]{this.minimum, this.maximum, this.comparator};
        return String.format(string2, objectArray);
    }

    private static final class ComparableComparator
    extends Enum<ComparableComparator>
    implements Comparator {
        private static final /* synthetic */ ComparableComparator[] $VALUES;
        public static final /* enum */ ComparableComparator INSTANCE = new ComparableComparator();

        static {
            ComparableComparator[] comparableComparatorArray = new ComparableComparator[]{INSTANCE};
            $VALUES = comparableComparatorArray;
        }

        public static ComparableComparator valueOf(String string2) {
            return Enum.valueOf(ComparableComparator.class, string2);
        }

        public static ComparableComparator[] values() {
            return (ComparableComparator[])$VALUES.clone();
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }
}

