/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int n2) {
        return RandomStringUtils.random(n2, false, false);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, null, RANDOM);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char ... cArray) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, cArray, RANDOM);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray, Random random) {
        block17: {
            block19: {
                if (n2 == 0) {
                    return "";
                }
                if (n2 < 0) {
                    throw new IllegalArgumentException("Requested random string length " + n2 + " is less than 0.");
                }
                if (cArray != null && cArray.length == 0) {
                    throw new IllegalArgumentException("The chars array must not be empty");
                }
                if (n3 != 0 || n4 != 0) break block19;
                if (cArray != null) {
                    n4 = cArray.length;
                    break block17;
                } else if (!bl2 && !bl3) {
                    n4 = Integer.MAX_VALUE;
                    break block17;
                } else {
                    n4 = 123;
                    n3 = 32;
                }
                break block17;
            }
            if (n4 <= n3) {
                throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater than start (" + n3 + ")");
            }
        }
        char[] cArray2 = new char[n2];
        int n5 = n4 - n3;
        int n6 = n2;
        while (true) {
            int n7;
            block18: {
                block20: {
                    char c2;
                    block21: {
                        n7 = n6 - 1;
                        if (n6 == 0) {
                            return new String(cArray2);
                        }
                        c2 = cArray == null ? (char)(n3 + random.nextInt(n5)) : cArray[n3 + random.nextInt(n5)];
                        if (!(bl2 && Character.isLetter(c2) || bl3 && Character.isDigit(c2)) && (bl2 || bl3)) break block20;
                        if (c2 < '\udc00' || c2 > '\udfff') break block21;
                        if (n7 != 0) {
                            cArray2[n7] = c2;
                            cArray2[--n7] = (char)(55296 + random.nextInt(128));
                        }
                        break block18;
                    }
                    if (c2 >= '\ud800' && c2 <= '\udb7f') {
                        if (n7 == 0) {
                            ++n7;
                            break block18;
                        } else {
                            cArray2[n7] = (char)(56320 + random.nextInt(128));
                            cArray2[--n7] = c2;
                        }
                        break block18;
                    } else if (c2 >= '\udb80' && c2 <= '\udbff') {
                        ++n7;
                        break block18;
                    } else {
                        cArray2[n7] = c2;
                    }
                    break block18;
                }
                ++n7;
            }
            n6 = ++n7;
        }
    }

    public static String random(int n2, String string2) {
        if (string2 == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, string2.toCharArray());
    }

    public static String random(int n2, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, 0, 0, bl2, bl3);
    }

    public static String random(int n2, char ... cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, 0, cArray.length, false, false, cArray, RANDOM);
    }

    public static String randomAlphabetic(int n2) {
        return RandomStringUtils.random(n2, true, false);
    }

    public static String randomAlphanumeric(int n2) {
        return RandomStringUtils.random(n2, true, true);
    }

    public static String randomAscii(int n2) {
        return RandomStringUtils.random(n2, 32, 127, false, false);
    }

    public static String randomNumeric(int n2) {
        return RandomStringUtils.random(n2, false, true);
    }
}

