/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.text.StrBuilder;

public class ObjectUtils {
    public static final Null NULL = new Null();

    public static byte CONST(byte by2) {
        return by2;
    }

    public static char CONST(char c2) {
        return c2;
    }

    public static double CONST(double d2) {
        return d2;
    }

    public static float CONST(float f2) {
        return f2;
    }

    public static int CONST(int n2) {
        return n2;
    }

    public static long CONST(long l2) {
        return l2;
    }

    public static <T> T CONST(T t2) {
        return t2;
    }

    public static short CONST(short s2) {
        return s2;
    }

    public static boolean CONST(boolean bl2) {
        return bl2;
    }

    public static byte CONST_BYTE(int n2) throws IllegalArgumentException {
        if (n2 < -128 || n2 > 127) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -128 and 127: [" + n2 + "]");
        }
        return (byte)n2;
    }

    public static short CONST_SHORT(int n2) throws IllegalArgumentException {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -32768 and 32767: [" + n2 + "]");
        }
        return (short)n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T clone(T t2) {
        Object object;
        if (!(t2 instanceof Cloneable)) return null;
        if (t2.getClass().isArray()) {
            Class<?> clazz = t2.getClass().getComponentType();
            if (!clazz.isPrimitive()) {
                object = ((Object[])t2).clone();
                return (T)object;
            }
            int n2 = Array.getLength(t2);
            object = Array.newInstance(clazz, n2);
            int n3 = n2;
            while (true) {
                int n4 = n3 - 1;
                if (n3 <= 0) return (T)object;
                Array.set(object, n4, Array.get(t2, n4));
                n3 = n4;
            }
        }
        try {
            Object object2;
            object = object2 = t2.getClass().getMethod("clone", new Class[0]).invoke(t2, new Object[0]);
            return (T)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CloneFailedException("Cloneable type " + t2.getClass().getName() + " has no clone method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneFailedException("Cannot clone Cloneable type " + t2.getClass().getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CloneFailedException("Exception cloning Cloneable type " + t2.getClass().getName(), invocationTargetException.getCause());
        }
    }

    public static <T> T cloneIfPossible(T t2) {
        T t3 = ObjectUtils.clone(t2);
        if (t3 == null) {
            return t2;
        }
        return t3;
    }

    public static <T extends Comparable<? super T>> int compare(T t2, T t3) {
        return ObjectUtils.compare(t2, t3, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Comparable<? super T>> int compare(T t2, T t3, boolean bl2) {
        int n2 = 1;
        int n3 = -1;
        if (t2 == t3) {
            return 0;
        }
        if (t2 == null) {
            if (bl2) return n2;
            return n3;
        }
        if (t3 != null) return t2.compareTo(t3);
        if (!bl2) return n2;
        return n3;
    }

    public static <T> T defaultIfNull(T t2, T t3) {
        if (t2 != null) {
            return t2;
        }
        return t3;
    }

    @Deprecated
    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static <T> T firstNonNull(T ... TArray) {
        if (TArray != null) {
            for (T t2 : TArray) {
                if (t2 == null) continue;
                return t2;
            }
        }
        return null;
    }

    @Deprecated
    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    @Deprecated
    public static int hashCodeMulti(Object ... objectArray) {
        int n2 = 1;
        if (objectArray != null) {
            for (Object object : objectArray) {
                n2 = n2 * 31 + ObjectUtils.hashCode(object);
            }
        }
        return n2;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ObjectUtils.identityToString(stringBuilder, object);
        return stringBuilder.toString();
    }

    public static void identityToString(Appendable appendable, Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        appendable.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        stringBuffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        stringBuilder.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StrBuilder strBuilder, Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        ((StrBuilder)strBuilder.append(object.getClass().getName()).append('@')).append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static <T extends Comparable<? super T>> T max(T ... TArray) {
        T t2 = null;
        if (TArray != null) {
            for (T t3 : TArray) {
                if (ObjectUtils.compare(t3, t2, false) <= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    public static <T extends Comparable<? super T>> T median(T ... TArray) {
        Validate.notEmpty(TArray);
        Validate.noNullElements(TArray);
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, TArray);
        return (T)((Comparable)treeSet.toArray()[(-1 + treeSet.size()) / 2]);
    }

    public static <T> T median(Comparator<T> comparator, T ... TArray) {
        Validate.notEmpty(TArray, "null/empty items", new Object[0]);
        Validate.noNullElements(TArray);
        Validate.notNull(comparator, "null comparator", new Object[0]);
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        Collections.addAll(treeSet, TArray);
        return (T)treeSet.toArray()[(-1 + treeSet.size()) / 2];
    }

    public static <T extends Comparable<? super T>> T min(T ... TArray) {
        T t2 = null;
        if (TArray != null) {
            for (T t3 : TArray) {
                if (ObjectUtils.compare(t3, t2, true) >= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T mode(T ... TArray) {
        Object var4_6;
        if (!ArrayUtils.isNotEmpty(TArray)) {
            var4_6 = null;
            return var4_6;
        } else {
            HashMap<T, MutableInt> hashMap = new HashMap<T, MutableInt>(TArray.length);
            for (T t2 : TArray) {
                MutableInt mutableInt = (MutableInt)hashMap.get(t2);
                if (mutableInt == null) {
                    hashMap.put(t2, new MutableInt(1));
                    continue;
                }
                mutableInt.increment();
            }
            var4_6 = null;
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n3 = ((MutableInt)entry.getValue()).intValue();
                if (n3 == n2) {
                    var4_6 = null;
                    continue;
                }
                if (n3 <= n2) continue;
                n2 = n3;
                var4_6 = entry.getKey();
            }
        }
        return var4_6;
    }

    public static boolean notEqual(Object object, Object object2) {
        return !ObjectUtils.equals(object, object2);
    }

    @Deprecated
    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    @Deprecated
    public static String toString(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

