/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocaleUtils {
    private static final ConcurrentMap<String, List<Locale>> cCountriesByLanguage;
    private static final ConcurrentMap<String, List<Locale>> cLanguagesByCountry;

    static {
        cLanguagesByCountry = new ConcurrentHashMap<String, List<Locale>>();
        cCountriesByLanguage = new ConcurrentHashMap<String, List<Locale>>();
    }

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_LIST;
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_SET;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Locale> countriesByLanguage(String string2) {
        if (string2 == null) {
            return Collections.emptyList();
        }
        List list = (List)cCountriesByLanguage.get(string2);
        if (list != null) return list;
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        List<Locale> list2 = LocaleUtils.availableLocaleList();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            Locale locale = list2.get(i2);
            if (!string2.equals(locale.getLanguage()) || locale.getCountry().length() == 0 || !locale.getVariant().isEmpty()) continue;
            arrayList.add(locale);
        }
        List list3 = Collections.unmodifiableList(arrayList);
        cCountriesByLanguage.putIfAbsent(string2, list3);
        return (List)cCountriesByLanguage.get(string2);
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains(locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Locale> languagesByCountry(String string2) {
        if (string2 == null) {
            return Collections.emptyList();
        }
        List list = (List)cLanguagesByCountry.get(string2);
        if (list != null) return list;
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        List<Locale> list2 = LocaleUtils.availableLocaleList();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            Locale locale = list2.get(i2);
            if (!string2.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue;
            arrayList.add(locale);
        }
        List list3 = Collections.unmodifiableList(arrayList);
        cLanguagesByCountry.putIfAbsent(string2, list3);
        return (List)cLanguagesByCountry.get(string2);
    }

    public static List<Locale> localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List<Locale> localeLookupList(Locale locale, Locale locale2) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (locale != null) {
            arrayList.add(locale);
            if (locale.getVariant().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), ""));
            }
            if (!arrayList.contains(locale2)) {
                arrayList.add(locale2);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Locale toLocale(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.isEmpty()) {
            return new Locale("", "");
        }
        if (string2.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        int n2 = string2.length();
        if (n2 < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        char c2 = string2.charAt(0);
        if (c2 == '_') {
            if (n2 < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + string2);
            }
            char c3 = string2.charAt(1);
            char c4 = string2.charAt(2);
            if (!Character.isUpperCase(c3) || !Character.isUpperCase(c4)) {
                throw new IllegalArgumentException("Invalid locale format: " + string2);
            }
            if (n2 == 3) {
                return new Locale("", string2.substring(1, 3));
            }
            if (n2 < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + string2);
            }
            if (string2.charAt(3) != '_') {
                throw new IllegalArgumentException("Invalid locale format: " + string2);
            }
            return new Locale("", string2.substring(1, 3), string2.substring(4));
        }
        char c5 = string2.charAt(1);
        if (!Character.isLowerCase(c2) || !Character.isLowerCase(c5)) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        if (n2 == 2) {
            return new Locale(string2);
        }
        if (n2 < 5) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        if (string2.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        char c6 = string2.charAt(3);
        if (c6 == '_') {
            return new Locale(string2.substring(0, 2), "", string2.substring(4));
        }
        char c7 = string2.charAt(4);
        if (!Character.isUpperCase(c6) || !Character.isUpperCase(c7)) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        if (n2 == 5) {
            return new Locale(string2.substring(0, 2), string2.substring(3, 5));
        }
        if (n2 < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        if (string2.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + string2);
        }
        return new Locale(string2.substring(0, 2), string2.substring(3, 5), string2.substring(6));
    }

    static class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_LIST;
        private static final Set<Locale> AVAILABLE_LOCALE_SET;

        static {
            ArrayList<Locale> arrayList = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
            AVAILABLE_LOCALE_LIST = Collections.unmodifiableList(arrayList);
            AVAILABLE_LOCALE_SET = Collections.unmodifiableSet(new HashSet<Locale>(arrayList));
        }

        SyncAvoid() {
        }
    }
}

