/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> clazz) {
        Validate.notNull(clazz, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Validate.isTrue(clazz.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, clazz);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> clazz) {
        Enum[] enumArray = (Enum[])EnumUtils.asEnum(clazz).getEnumConstants();
        boolean bl2 = enumArray.length <= 64;
        Object[] objectArray = new Object[]{enumArray.length, clazz.getSimpleName(), 64};
        Validate.isTrue(bl2, CANNOT_STORE_S_S_VALUES_IN_S_BITS, objectArray);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, Iterable<E> iterable) {
        EnumUtils.checkBitVectorable(clazz);
        Validate.notNull(iterable);
        long l2 = 0L;
        Iterator<E> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Enum enum_ = (Enum)iterator.next();
            boolean bl2 = enum_ != null;
            Validate.isTrue(bl2, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            l2 |= (long)(1 << enum_.ordinal());
        }
        return l2;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, E ... EArray) {
        Validate.noNullElements(EArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(EArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> clazz, Iterable<E> iterable) {
        EnumUtils.asEnum(clazz);
        Validate.notNull(iterable);
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        for (Enum enum_ : iterable) {
            boolean bl2 = enum_ != null;
            Validate.isTrue(bl2, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            enumSet.add(enum_);
        }
        long[] lArray = new long[1 + (-1 + ((Enum[])clazz.getEnumConstants()).length) / 64];
        Iterator iterator = enumSet.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ArrayUtils.reverse(lArray);
                return lArray;
            }
            Enum enum_ = (Enum)iterator.next();
            int n2 = enum_.ordinal() / 64;
            lArray[n2] = lArray[n2] | (long)(1 << enum_.ordinal() % 64);
        }
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> clazz, E ... EArray) {
        EnumUtils.asEnum(clazz);
        Validate.noNullElements(EArray);
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        Collections.addAll(enumSet, EArray);
        long[] lArray = new long[1 + (-1 + ((Enum[])clazz.getEnumConstants()).length) / 64];
        for (Enum enum_ : enumSet) {
            int n2 = enum_.ordinal() / 64;
            lArray[n2] = lArray[n2] | (long)(1 << enum_.ordinal() % 64);
        }
        ArrayUtils.reverse(lArray);
        return lArray;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string2) {
        E e2;
        if (string2 == null) {
            return null;
        }
        try {
            e2 = Enum.valueOf(clazz, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return e2;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<E>(Arrays.asList(clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> clazz) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string2) {
        if (string2 == null) {
            return false;
        }
        try {
            Enum.valueOf(clazz, string2);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> clazz, long l2) {
        EnumUtils.checkBitVectorable(clazz).getEnumConstants();
        return EnumUtils.processBitVectors(clazz, l2);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> clazz, long ... lArray) {
        EnumSet<Enum> enumSet = EnumSet.noneOf(EnumUtils.asEnum(clazz));
        long[] lArray2 = ArrayUtils.clone(Validate.notNull(lArray));
        ArrayUtils.reverse(lArray2);
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            int n2 = enum_.ordinal() / 64;
            if (n2 >= lArray2.length || (lArray2[n2] & (long)(1 << enum_.ordinal() % 64)) == 0L) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }
}

