/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.UUID;

public class Conversion {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !Conversion.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
    }

    public static char binaryBeMsb0ToHexDigit(boolean[] blArray) {
        return Conversion.binaryBeMsb0ToHexDigit(blArray, 0);
    }

    public static char binaryBeMsb0ToHexDigit(boolean[] blArray, int n2) {
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array.");
        }
        int n3 = -1 + blArray.length - n2;
        int n4 = Math.min(4, n3 + 1);
        boolean[] blArray2 = new boolean[4];
        System.arraycopy(blArray, n3 + 1 - n4, blArray2, 4 - n4, n4);
        if (blArray2[0]) {
            if (blArray2.length > 1 && blArray2[1]) {
                if (blArray2.length > 2 && blArray2[2]) {
                    if (blArray2.length > 3 && blArray2[3]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (blArray2.length > 3 && blArray2[3]) {
                    return 'd';
                }
                return 'c';
            }
            if (blArray2.length > 2 && blArray2[2]) {
                if (blArray2.length > 3 && blArray2[3]) {
                    return 'b';
                }
                return 'a';
            }
            if (blArray2.length > 3 && blArray2[3]) {
                return '9';
            }
            return '8';
        }
        if (blArray2.length > 1 && blArray2[1]) {
            if (blArray2.length > 2 && blArray2[2]) {
                if (blArray2.length > 3 && blArray2[3]) {
                    return '7';
                }
                return '6';
            }
            if (blArray2.length > 3 && blArray2[3]) {
                return '5';
            }
            return '4';
        }
        if (blArray2.length > 2 && blArray2[2]) {
            if (blArray2.length > 3 && blArray2[3]) {
                return '3';
            }
            return '2';
        }
        if (blArray2.length > 3 && blArray2[3]) {
            return '1';
        }
        return '0';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte binaryToByte(boolean[] blArray, int n2, byte by2, int n3, int n4) {
        if (blArray.length == 0 && n2 == 0 || n4 == 0) {
            return by2;
        }
        if (n3 + (n4 - 1) >= 8) {
            throw new IllegalArgumentException("nBools-1+dstPos is greather or equal to than 8");
        }
        byte by3 = by2;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 + n5 * 1;
            int n7 = blArray[n5 + n2] ? 1 : 0;
            by3 = (byte)(n7 << n6 | by3 & (0xFFFFFFFF ^ 1 << n6));
            ++n5;
        }
        return by3;
    }

    public static char binaryToHexDigit(boolean[] blArray) {
        return Conversion.binaryToHexDigit(blArray, 0);
    }

    public static char binaryToHexDigit(boolean[] blArray, int n2) {
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array.");
        }
        if (blArray.length > n2 + 3 && blArray[n2 + 3]) {
            if (blArray.length > n2 + 2 && blArray[n2 + 2]) {
                if (blArray.length > n2 + 1 && blArray[n2 + 1]) {
                    if (blArray[n2]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (blArray[n2]) {
                    return 'd';
                }
                return 'c';
            }
            if (blArray.length > n2 + 1 && blArray[n2 + 1]) {
                if (blArray[n2]) {
                    return 'b';
                }
                return 'a';
            }
            if (blArray[n2]) {
                return '9';
            }
            return '8';
        }
        if (blArray.length > n2 + 2 && blArray[n2 + 2]) {
            if (blArray.length > n2 + 1 && blArray[n2 + 1]) {
                if (blArray[n2]) {
                    return '7';
                }
                return '6';
            }
            if (blArray[n2]) {
                return '5';
            }
            return '4';
        }
        if (blArray.length > n2 + 1 && blArray[n2 + 1]) {
            if (blArray[n2]) {
                return '3';
            }
            return '2';
        }
        if (blArray[n2]) {
            return '1';
        }
        return '0';
    }

    public static char binaryToHexDigitMsb0_4bits(boolean[] blArray) {
        return Conversion.binaryToHexDigitMsb0_4bits(blArray, 0);
    }

    public static char binaryToHexDigitMsb0_4bits(boolean[] blArray, int n2) {
        if (blArray.length > 8) {
            throw new IllegalArgumentException("src.length>8: src.length=" + blArray.length);
        }
        if (blArray.length - n2 < 4) {
            throw new IllegalArgumentException("src.length-srcPos<4: src.length=" + blArray.length + ", srcPos=" + n2);
        }
        if (blArray[n2 + 3]) {
            if (blArray[n2 + 2]) {
                if (blArray[n2 + 1]) {
                    if (blArray[n2]) {
                        return 'f';
                    }
                    return '7';
                }
                if (blArray[n2]) {
                    return 'b';
                }
                return '3';
            }
            if (blArray[n2 + 1]) {
                if (blArray[n2]) {
                    return 'd';
                }
                return '5';
            }
            if (blArray[n2]) {
                return '9';
            }
            return '1';
        }
        if (blArray[n2 + 2]) {
            if (blArray[n2 + 1]) {
                if (blArray[n2]) {
                    return 'e';
                }
                return '6';
            }
            if (blArray[n2]) {
                return 'a';
            }
            return '2';
        }
        if (blArray[n2 + 1]) {
            if (blArray[n2]) {
                return 'c';
            }
            return '4';
        }
        if (blArray[n2]) {
            return '8';
        }
        return '0';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int binaryToInt(boolean[] blArray, int n2, int n3, int n4, int n5) {
        if (blArray.length == 0 && n2 == 0 || n5 == 0) {
            return n3;
        }
        if (n4 + (n5 - 1) >= 32) {
            throw new IllegalArgumentException("nBools-1+dstPos is greather or equal to than 32");
        }
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = n4 + n7 * 1;
            int n9 = blArray[n7 + n2] ? 1 : 0;
            n6 = n9 << n8 | n6 & (0xFFFFFFFF ^ 1 << n8);
            ++n7;
        }
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long binaryToLong(boolean[] blArray, int n2, long l2, int n3, int n4) {
        if (blArray.length == 0 && n2 == 0 || n4 == 0) {
            return l2;
        }
        if (n3 + (n4 - 1) >= 64) {
            throw new IllegalArgumentException("nBools-1+dstPos is greather or equal to than 64");
        }
        long l3 = l2;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 + n5 * 1;
            long l4 = blArray[n5 + n2] ? 1L : 0L;
            l3 = l4 << n6 | l3 & (0xFFFFFFFFFFFFFFFFL ^ 1L << n6);
            ++n5;
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static short binaryToShort(boolean[] blArray, int n2, short s2, int n3, int n4) {
        if (blArray.length == 0 && n2 == 0 || n4 == 0) {
            return s2;
        }
        if (n3 + (n4 - 1) >= 16) {
            throw new IllegalArgumentException("nBools-1+dstPos is greather or equal to than 16");
        }
        short s3 = s2;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 + n5 * 1;
            int n7 = blArray[n5 + n2] ? 1 : 0;
            s3 = (short)(n7 << n6 | s3 & (0xFFFFFFFF ^ 1 << n6));
            ++n5;
        }
        return s3;
    }

    public static int byteArrayToInt(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (byArray.length == 0 && n2 == 0 || n5 == 0) {
            return n3;
        }
        if (n4 + 8 * (n5 - 1) >= 32) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greather or equal to than 32");
        }
        int n6 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = n4 + i2 * 8;
            n6 = (0xFF & byArray[i2 + n2]) << n7 | n6 & (0xFFFFFFFF ^ 255 << n7);
        }
        return n6;
    }

    public static long byteArrayToLong(byte[] byArray, int n2, long l2, int n3, int n4) {
        if (byArray.length == 0 && n2 == 0 || n4 == 0) {
            return l2;
        }
        if (n3 + 8 * (n4 - 1) >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greather or equal to than 64");
        }
        long l3 = l2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 8;
            l3 = (0xFFL & (long)byArray[i2 + n2]) << n5 | l3 & (0xFFFFFFFFFFFFFFFFL ^ 255L << n5);
        }
        return l3;
    }

    public static short byteArrayToShort(byte[] byArray, int n2, short s2, int n3, int n4) {
        if (byArray.length == 0 && n2 == 0 || n4 == 0) {
            return s2;
        }
        if (n3 + 8 * (n4 - 1) >= 16) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greather or equal to than 16");
        }
        short s3 = s2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 8;
            s3 = (short)((0xFF & byArray[i2 + n2]) << n5 | s3 & (0xFFFFFFFF ^ 255 << n5));
        }
        return s3;
    }

    public static UUID byteArrayToUuid(byte[] byArray, int n2) {
        if (byArray.length - n2 < 16) {
            throw new IllegalArgumentException("Need at least 16 bytes for UUID");
        }
        return new UUID(Conversion.byteArrayToLong(byArray, n2, 0L, 0, 8), Conversion.byteArrayToLong(byArray, n2 + 8, 0L, 0, 8));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] byteToBinary(byte by2, int n2, boolean[] blArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + (n4 - 1) >= 8) {
                throw new IllegalArgumentException("nBools-1+srcPos is greather or equal to than 8");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 1;
                int n6 = n3 + i2;
                boolean bl2 = (1 & by2 >> n5) != 0;
                blArray[n6] = bl2;
            }
        }
        return blArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String byteToHex(byte by2, int n2, String string2, int n3, int n4) {
        if (n4 == 0) {
            return string2;
        }
        if (n2 + 4 * (n4 - 1) >= 8) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greather or equal to than 8");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n5 = stringBuilder.length();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0xF & by2 >> n2 + n6 * 4;
            if (n3 + n6 == n5) {
                ++n5;
                stringBuilder.append(Conversion.intToHexDigit(n7));
            } else {
                stringBuilder.setCharAt(n3 + n6, Conversion.intToHexDigit(n7));
            }
            ++n6;
        }
        return stringBuilder.toString();
    }

    public static boolean[] hexDigitMsb0ToBinary(char c2) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
            }
            case '0': {
                return new boolean[]{false, false, false, false};
            }
            case '1': {
                return new boolean[]{false, false, false, true};
            }
            case '2': {
                return new boolean[]{false, false, true, false};
            }
            case '3': {
                return new boolean[]{false, false, true, true};
            }
            case '4': {
                return new boolean[]{false, true, false, false};
            }
            case '5': {
                return new boolean[]{false, true, false, true};
            }
            case '6': {
                return new boolean[]{false, true, true, false};
            }
            case '7': {
                return new boolean[]{false, true, true, true};
            }
            case '8': {
                return new boolean[]{true, false, false, false};
            }
            case '9': {
                return new boolean[]{true, false, false, true};
            }
            case 'A': 
            case 'a': {
                return new boolean[]{true, false, true, false};
            }
            case 'B': 
            case 'b': {
                return new boolean[]{true, false, true, true};
            }
            case 'C': 
            case 'c': {
                return new boolean[]{true, true, false, false};
            }
            case 'D': 
            case 'd': {
                return new boolean[]{true, true, false, true};
            }
            case 'E': 
            case 'e': {
                return new boolean[]{true, true, true, false};
            }
            case 'F': 
            case 'f': 
        }
        return new boolean[]{true, true, true, true};
    }

    public static int hexDigitMsb0ToInt(char c2) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
            }
            case '0': {
                return 0;
            }
            case '1': {
                return 8;
            }
            case '2': {
                return 4;
            }
            case '3': {
                return 12;
            }
            case '4': {
                return 2;
            }
            case '5': {
                return 10;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 14;
            }
            case '8': {
                return 1;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 5;
            }
            case 'B': 
            case 'b': {
                return 13;
            }
            case 'C': 
            case 'c': {
                return 3;
            }
            case 'D': 
            case 'd': {
                return 11;
            }
            case 'E': 
            case 'e': {
                return 7;
            }
            case 'F': 
            case 'f': 
        }
        return 15;
    }

    public static boolean[] hexDigitToBinary(char c2) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
            }
            case '0': {
                return new boolean[]{false, false, false, false};
            }
            case '1': {
                return new boolean[]{true, false, false, false};
            }
            case '2': {
                return new boolean[]{false, true, false, false};
            }
            case '3': {
                return new boolean[]{true, true, false, false};
            }
            case '4': {
                return new boolean[]{false, false, true, false};
            }
            case '5': {
                return new boolean[]{true, false, true, false};
            }
            case '6': {
                return new boolean[]{false, true, true, false};
            }
            case '7': {
                return new boolean[]{true, true, true, false};
            }
            case '8': {
                return new boolean[]{false, false, false, true};
            }
            case '9': {
                return new boolean[]{true, false, false, true};
            }
            case 'A': 
            case 'a': {
                return new boolean[]{false, true, false, true};
            }
            case 'B': 
            case 'b': {
                return new boolean[]{true, true, false, true};
            }
            case 'C': 
            case 'c': {
                return new boolean[]{false, false, true, true};
            }
            case 'D': 
            case 'd': {
                return new boolean[]{true, false, true, true};
            }
            case 'E': 
            case 'e': {
                return new boolean[]{false, true, true, true};
            }
            case 'F': 
            case 'f': 
        }
        return new boolean[]{true, true, true, true};
    }

    public static int hexDigitToInt(char c2) {
        int n2 = Character.digit(c2, 16);
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot interpret '" + c2 + "' as a hexadecimal digit");
        }
        return n2;
    }

    public static byte hexToByte(String string2, int n2, byte by2, int n3, int n4) {
        if (n4 == 0) {
            return by2;
        }
        if (n3 + 4 * (n4 - 1) >= 8) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greather or equal to than 8");
        }
        byte by3 = by2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 4;
            by3 = (byte)((0xF & Conversion.hexDigitToInt(string2.charAt(i2 + n2))) << n5 | by3 & (0xFFFFFFFF ^ 15 << n5));
        }
        return by3;
    }

    public static int hexToInt(String string2, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            return n3;
        }
        if (n4 + 4 * (n5 - 1) >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greather or equal to than 32");
        }
        int n6 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = n4 + i2 * 4;
            n6 = (0xF & Conversion.hexDigitToInt(string2.charAt(i2 + n2))) << n7 | n6 & (0xFFFFFFFF ^ 15 << n7);
        }
        return n6;
    }

    public static long hexToLong(String string2, int n2, long l2, int n3, int n4) {
        if (n4 == 0) {
            return l2;
        }
        if (n3 + 4 * (n4 - 1) >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greather or equal to than 64");
        }
        long l3 = l2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 4;
            l3 = (0xFL & (long)Conversion.hexDigitToInt(string2.charAt(i2 + n2))) << n5 | l3 & (0xFFFFFFFFFFFFFFFFL ^ 15L << n5);
        }
        return l3;
    }

    public static short hexToShort(String string2, int n2, short s2, int n3, int n4) {
        if (n4 == 0) {
            return s2;
        }
        if (n3 + 4 * (n4 - 1) >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greather or equal to than 16");
        }
        short s3 = s2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 4;
            s3 = (short)((0xF & Conversion.hexDigitToInt(string2.charAt(i2 + n2))) << n5 | s3 & (0xFFFFFFFF ^ 15 << n5));
        }
        return s3;
    }

    public static long intArrayToLong(int[] nArray, int n2, long l2, int n3, int n4) {
        if (nArray.length == 0 && n2 == 0 || n4 == 0) {
            return l2;
        }
        if (n3 + 32 * (n4 - 1) >= 64) {
            throw new IllegalArgumentException("(nInts-1)*32+dstPos is greather or equal to than 64");
        }
        long l3 = l2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 32;
            l3 = (0xFFFFFFFFL & (long)nArray[i2 + n2]) << n5 | l3 & (0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFL << n5);
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] intToBinary(int n2, int n3, boolean[] blArray, int n4, int n5) {
        if (n5 != 0) {
            if (n3 + (n5 - 1) >= 32) {
                throw new IllegalArgumentException("nBools-1+srcPos is greather or equal to than 32");
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = n3 + i2 * 1;
                int n7 = n4 + i2;
                boolean bl2 = (1 & n2 >> n6) != 0;
                blArray[n7] = bl2;
            }
        }
        return blArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] intToByteArray(int n2, int n3, byte[] byArray, int n4, int n5) {
        if (n5 != 0) {
            if (n3 + 8 * (n5 - 1) >= 32) {
                throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greather or equal to than 32");
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = n3 + i2 * 8;
                byArray[n4 + i2] = (byte)(0xFF & n2 >> n6);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String intToHex(int n2, int n3, String string2, int n4, int n5) {
        if (n5 == 0) {
            return string2;
        }
        if (n3 + 4 * (n5 - 1) >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greather or equal to than 32");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n6 = stringBuilder.length();
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0xF & n2 >> n3 + n7 * 4;
            if (n4 + n7 == n6) {
                ++n6;
                stringBuilder.append(Conversion.intToHexDigit(n8));
            } else {
                stringBuilder.setCharAt(n4 + n7, Conversion.intToHexDigit(n8));
            }
            ++n7;
        }
        return stringBuilder.toString();
    }

    public static char intToHexDigit(int n2) {
        char c2 = Character.forDigit(n2, 16);
        if (c2 == '\u0000') {
            throw new IllegalArgumentException("nibble value not between 0 and 15: " + n2);
        }
        return c2;
    }

    public static char intToHexDigitMsb0(int n2) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("nibble value not between 0 and 15: " + n2);
            }
            case 0: {
                return '0';
            }
            case 1: {
                return '8';
            }
            case 2: {
                return '4';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return '2';
            }
            case 5: {
                return 'a';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return 'e';
            }
            case 8: {
                return '1';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '5';
            }
            case 11: {
                return 'd';
            }
            case 12: {
                return '3';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return '7';
            }
            case 15: 
        }
        return 'f';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static short[] intToShortArray(int n2, int n3, short[] sArray, int n4, int n5) {
        if (n5 != 0) {
            if (n3 + 16 * (n5 - 1) >= 32) {
                throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greather or equal to than 32");
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = n3 + i2 * 16;
                sArray[n4 + i2] = (short)(0xFFFF & n2 >> n6);
            }
        }
        return sArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] longToBinary(long l2, int n2, boolean[] blArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + (n4 - 1) >= 64) {
                throw new IllegalArgumentException("nBools-1+srcPos is greather or equal to than 64");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 1;
                int n6 = n3 + i2;
                boolean bl2 = (1L & l2 >> n5) != 0L;
                blArray[n6] = bl2;
            }
        }
        return blArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] longToByteArray(long l2, int n2, byte[] byArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + 8 * (n4 - 1) >= 64) {
                throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greather or equal to than 64");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 8;
                byArray[n3 + i2] = (byte)(0xFFL & l2 >> n5);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String longToHex(long l2, int n2, String string2, int n3, int n4) {
        if (n4 == 0) {
            return string2;
        }
        if (n2 + 4 * (n4 - 1) >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greather or equal to than 64");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n5 = stringBuilder.length();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = (int)(0xFL & l2 >> n2 + n6 * 4);
            if (n3 + n6 == n5) {
                ++n5;
                stringBuilder.append(Conversion.intToHexDigit(n7));
            } else {
                stringBuilder.setCharAt(n3 + n6, Conversion.intToHexDigit(n7));
            }
            ++n6;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int[] longToIntArray(long l2, int n2, int[] nArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + 32 * (n4 - 1) >= 64) {
                throw new IllegalArgumentException("(nInts-1)*32+srcPos is greather or equal to than 64");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 32;
                nArray[n3 + i2] = (int)(0xFFFFFFFFFFFFFFFFL & l2 >> n5);
            }
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static short[] longToShortArray(long l2, int n2, short[] sArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + 16 * (n4 - 1) >= 64) {
                throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greather or equal to than 64");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 16;
                sArray[n3 + i2] = (short)(0xFFFFL & l2 >> n5);
            }
        }
        return sArray;
    }

    public static int shortArrayToInt(short[] sArray, int n2, int n3, int n4, int n5) {
        if (sArray.length == 0 && n2 == 0 || n5 == 0) {
            return n3;
        }
        if (n4 + 16 * (n5 - 1) >= 32) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greather or equal to than 32");
        }
        int n6 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = n4 + i2 * 16;
            n6 = (0xFFFF & sArray[i2 + n2]) << n7 | n6 & (0xFFFFFFFF ^ 65535 << n7);
        }
        return n6;
    }

    public static long shortArrayToLong(short[] sArray, int n2, long l2, int n3, int n4) {
        if (sArray.length == 0 && n2 == 0 || n4 == 0) {
            return l2;
        }
        if (n3 + 16 * (n4 - 1) >= 64) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greather or equal to than 64");
        }
        long l3 = l2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2 * 16;
            l3 = (0xFFFFL & (long)sArray[i2 + n2]) << n5 | l3 & (0xFFFFFFFFFFFFFFFFL ^ 65535L << n5);
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] shortToBinary(short s2, int n2, boolean[] blArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + (n4 - 1) >= 16) {
                throw new IllegalArgumentException("nBools-1+srcPos is greather or equal to than 16");
            }
            if (!$assertionsDisabled && 1 * (n4 - 1) >= 16 - n2) {
                throw new AssertionError();
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 1;
                int n6 = n3 + i2;
                boolean bl2 = (1 & s2 >> n5) != 0;
                blArray[n6] = bl2;
            }
        }
        return blArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] shortToByteArray(short s2, int n2, byte[] byArray, int n3, int n4) {
        if (n4 != 0) {
            if (n2 + 8 * (n4 - 1) >= 16) {
                throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greather or equal to than 16");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n2 + i2 * 8;
                byArray[n3 + i2] = (byte)(0xFF & s2 >> n5);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String shortToHex(short s2, int n2, String string2, int n3, int n4) {
        if (n4 == 0) {
            return string2;
        }
        if (n2 + 4 * (n4 - 1) >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greather or equal to than 16");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n5 = stringBuilder.length();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0xF & s2 >> n2 + n6 * 4;
            if (n3 + n6 == n5) {
                ++n5;
                stringBuilder.append(Conversion.intToHexDigit(n7));
            } else {
                stringBuilder.setCharAt(n3 + n6, Conversion.intToHexDigit(n7));
            }
            ++n6;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] uuidToByteArray(UUID uUID, byte[] byArray, int n2, int n3) {
        block5: {
            block4: {
                if (n3 == 0) break block4;
                if (n3 > 16) {
                    throw new IllegalArgumentException("nBytes is greather than 16");
                }
                long l2 = uUID.getMostSignificantBits();
                int n4 = n3 > 8 ? 8 : n3;
                Conversion.longToByteArray(l2, 0, byArray, n2, n4);
                if (n3 >= 8) break block5;
            }
            return byArray;
        }
        Conversion.longToByteArray(uUID.getLeastSignificantBits(), 0, byArray, n2 + 8, n3 - 8);
        return byArray;
    }
}

