/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class ClassUtils {
    public static final String INNER_CLASS_SEPARATOR;
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String PACKAGE_SEPARATOR;
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final Map<String, String> abbreviationMap;
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<String, String> reverseAbbreviationMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    static {
        PACKAGE_SEPARATOR = String.valueOf('.');
        INNER_CLASS_SEPARATOR = String.valueOf('$');
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        for (Class<?> clazz : primitiveWrapperMap.keySet()) {
            Class<?> clazz2;
            if (clazz.equals(clazz2 = primitiveWrapperMap.get(clazz))) continue;
            wrapperPrimitiveMap.put(clazz2, clazz);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("int", "I");
        hashMap.put("boolean", "Z");
        hashMap.put("float", "F");
        hashMap.put("long", "J");
        hashMap.put("short", "S");
        hashMap.put("byte", "B");
        hashMap.put("double", "D");
        hashMap.put("char", "C");
        hashMap.put("void", "V");
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        abbreviationMap = Collections.unmodifiableMap(hashMap);
        reverseAbbreviationMap = Collections.unmodifiableMap(hashMap2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> convertClassNamesToClasses(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            try {
                arrayList.add(Class.forName(string2));
            }
            catch (Exception exception) {
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> convertClassesToClassNames(List<Class<?>> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator<Class<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (clazz == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(clazz.getName());
        }
        return arrayList;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ClassUtils.getAllInterfaces(clazz, linkedHashSet);
        return new ArrayList(linkedHashSet);
    }

    private static void getAllInterfaces(Class<?> clazz, HashSet<Class<?>> hashSet) {
        while (clazz != null) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!hashSet.add(clazz2)) continue;
                ClassUtils.getAllInterfaces(clazz2, hashSet);
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Class<?> clazz2 = clazz.getSuperclass();
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getCanonicalName(String string2) {
        String string3 = StringUtils.deleteWhitespace(string2);
        if (string3 == null) {
            return null;
        }
        int n2 = 0;
        while (string3.startsWith("[")) {
            ++n2;
            string3 = string3.substring(1);
        }
        if (n2 < 1) return string3;
        if (string3.startsWith("L")) {
            int n3 = string3.endsWith(";") ? -1 + string3.length() : string3.length();
            string3 = string3.substring(1, n3);
        } else if (string3.length() > 0) {
            string3 = reverseAbbreviationMap.get(string3.substring(0, 1));
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        int n4 = 0;
        while (n4 < n2) {
            stringBuilder.append("[]");
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static Class<?> getClass(ClassLoader classLoader, String string2) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, string2, true);
    }

    public static Class<?> getClass(ClassLoader classLoader, String string2, boolean bl2) throws ClassNotFoundException {
        try {
            if (abbreviationMap.containsKey(string2)) {
                return Class.forName("[" + abbreviationMap.get(string2), bl2, classLoader).getComponentType();
            }
            Class<?> clazz = Class.forName(ClassUtils.toCanonicalName(string2), bl2, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n2 = string2.lastIndexOf(46);
            if (n2 != -1) {
                try {
                    Class<?> clazz = ClassUtils.getClass(classLoader, string2.substring(0, n2) + '$' + string2.substring(n2 + 1), bl2);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    public static Class<?> getClass(String string2) throws ClassNotFoundException {
        return ClassUtils.getClass(string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getClass(String string2, boolean bl2) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 == null) {
            classLoader = ClassUtils.class.getClassLoader();
            return ClassUtils.getClass(classLoader, string2, bl2);
        }
        classLoader = classLoader2;
        return ClassUtils.getClass(classLoader, string2, bl2);
    }

    public static String getPackageCanonicalName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(clazz.getName());
    }

    public static String getPackageCanonicalName(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return ClassUtils.getPackageCanonicalName(object.getClass().getName());
    }

    public static String getPackageCanonicalName(String string2) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(string2));
    }

    public static String getPackageName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return ClassUtils.getPackageName(object.getClass());
    }

    public static String getPackageName(String string2) {
        int n2;
        if (StringUtils.isEmpty(string2)) {
            return "";
        }
        while (string2.charAt(0) == '[') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(0) == 'L' && string2.charAt(-1 + string2.length()) == ';') {
            string2 = string2.substring(1);
        }
        if ((n2 = string2.lastIndexOf(46)) == -1) {
            return "";
        }
        return string2.substring(0, n2);
    }

    public static Method getPublicMethod(Class<?> clazz, String string2, Class<?> ... classArray) throws SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(string2, classArray);
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ClassUtils.getAllInterfaces(clazz));
        arrayList.addAll(ClassUtils.getAllSuperclasses(clazz));
        for (Class clazz2 : arrayList) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {}
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            Method method2 = clazz2.getMethod(string2, classArray);
            if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) continue;
            return method2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + string2 + " " + ArrayUtils.toString(classArray));
    }

    public static String getShortCanonicalName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(clazz.getName());
    }

    public static String getShortCanonicalName(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return ClassUtils.getShortCanonicalName(object.getClass().getName());
    }

    public static String getShortCanonicalName(String string2) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(string2));
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getShortClassName(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.startsWith("[")) {
            while (string2.charAt(0) == '[') {
                string2 = string2.substring(1);
                stringBuilder.append("[]");
            }
            if (string2.charAt(0) == 'L' && string2.charAt(-1 + string2.length()) == ';') {
                string2 = string2.substring(1, -1 + string2.length());
            }
            if (reverseAbbreviationMap.containsKey(string2)) {
                string2 = reverseAbbreviationMap.get(string2);
            }
        }
        int n2 = string2.lastIndexOf(46);
        int n3 = 0;
        if (n2 != -1) {
            n3 = n2 + 1;
        }
        int n4 = string2.indexOf(36, n3);
        String string3 = string2.substring(n2 + 1);
        if (n4 != -1) {
            string3 = string3.replace('$', '.');
        }
        return string3 + stringBuilder;
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return clazz.getSimpleName();
    }

    public static String getSimpleName(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return ClassUtils.getSimpleName(object.getClass());
    }

    public static Iterable<Class<?>> hierarchy(Class<?> clazz) {
        return ClassUtils.hierarchy(clazz, Interfaces.EXCLUDE);
    }

    public static Iterable<Class<?>> hierarchy(final Class<?> clazz, Interfaces interfaces) {
        final Iterable iterable = new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                return new Iterator<Class<?>>(new MutableObject<Class>(clazz)){
                    final /* synthetic */ MutableObject val$next;
                    {
                        this.val$next = mutableObject;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$next.getValue() != null;
                    }

                    @Override
                    public Class<?> next() {
                        Class clazz = (Class)this.val$next.getValue();
                        this.val$next.setValue(clazz.getSuperclass());
                        return clazz;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (interfaces != Interfaces.INCLUDE) {
            return iterable;
        }
        return new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                HashSet hashSet = new HashSet();
                return new Iterator<Class<?>>(iterable.iterator(), hashSet){
                    Iterator<Class<?>> interfaces = Collections.emptySet().iterator();
                    final /* synthetic */ Set val$seenInterfaces;
                    final /* synthetic */ Iterator val$wrapped;
                    {
                        this.val$wrapped = iterator;
                        this.val$seenInterfaces = set;
                    }

                    private void walkInterfaces(Set<Class<?>> set, Class<?> clazz) {
                        for (Class<?> clazz2 : clazz.getInterfaces()) {
                            if (!this.val$seenInterfaces.contains(clazz2)) {
                                set.add(clazz2);
                            }
                            this.walkInterfaces(set, clazz2);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.interfaces.hasNext() || this.val$wrapped.hasNext();
                    }

                    @Override
                    public Class<?> next() {
                        if (this.interfaces.hasNext()) {
                            Class<?> clazz = this.interfaces.next();
                            this.val$seenInterfaces.add(clazz);
                            return clazz;
                        }
                        Class clazz = (Class)this.val$wrapped.next();
                        LinkedHashSet linkedHashSet = new LinkedHashSet();
                        this.walkInterfaces(linkedHashSet, clazz);
                        this.interfaces = linkedHashSet.iterator();
                        return clazz;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2) {
        return ClassUtils.isAssignable(clazz, clazz2, SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_1_5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        boolean bl3 = true;
        if (clazz2 == null) {
            return false;
        }
        if (clazz == null) {
            if (clazz2.isPrimitive()) return false;
            return bl3;
        }
        if (bl2) {
            if (clazz.isPrimitive() && !clazz2.isPrimitive()) {
                if ((clazz = ClassUtils.primitiveToWrapper(clazz)) == null) return false;
            }
            if (clazz2.isPrimitive() && !clazz.isPrimitive()) {
                if ((clazz = ClassUtils.wrapperToPrimitive(clazz)) == null) return false;
            }
        }
        if (clazz.equals(clazz2)) {
            return bl3;
        }
        if (!clazz.isPrimitive()) return clazz2.isAssignableFrom(clazz);
        if (!clazz2.isPrimitive()) return false;
        if (Integer.TYPE.equals(clazz)) {
            if (Long.TYPE.equals(clazz2)) return bl3;
            if (Float.TYPE.equals(clazz2)) return bl3;
            if (!Double.TYPE.equals(clazz2)) return false;
            return bl3;
        }
        if (Long.TYPE.equals(clazz)) {
            if (Float.TYPE.equals(clazz2)) return bl3;
            if (!Double.TYPE.equals(clazz2)) return false;
            return bl3;
        }
        if (Boolean.TYPE.equals(clazz)) return false;
        if (Double.TYPE.equals(clazz)) return false;
        if (Float.TYPE.equals(clazz)) {
            return Double.TYPE.equals(clazz2);
        }
        if (Character.TYPE.equals(clazz)) {
            if (Integer.TYPE.equals(clazz2)) return bl3;
            if (Long.TYPE.equals(clazz2)) return bl3;
            if (Float.TYPE.equals(clazz2)) return bl3;
            if (!Double.TYPE.equals(clazz2)) return false;
            return bl3;
        }
        if (Short.TYPE.equals(clazz)) {
            if (Integer.TYPE.equals(clazz2)) return bl3;
            if (Long.TYPE.equals(clazz2)) return bl3;
            if (Float.TYPE.equals(clazz2)) return bl3;
            if (!Double.TYPE.equals(clazz2)) return false;
            return bl3;
        }
        if (!Byte.TYPE.equals(clazz)) return false;
        if (Short.TYPE.equals(clazz2)) return bl3;
        if (Integer.TYPE.equals(clazz2)) return bl3;
        if (Long.TYPE.equals(clazz2)) return bl3;
        if (Float.TYPE.equals(clazz2)) return bl3;
        if (!Double.TYPE.equals(clazz2)) return false;
        return bl3;
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... classArray2) {
        return ClassUtils.isAssignable(classArray, classArray2, SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_1_5));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] classArray2, boolean bl2) {
        if (ArrayUtils.isSameLength(classArray, classArray2)) {
            if (classArray == null) {
                classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
            }
            if (classArray2 == null) {
                classArray2 = ArrayUtils.EMPTY_CLASS_ARRAY;
            }
            int n2 = 0;
            while (true) {
                if (n2 >= classArray.length) {
                    return true;
                }
                if (!ClassUtils.isAssignable(classArray[n2], classArray2[n2], bl2)) break;
                ++n2;
            }
        }
        return false;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz != null && clazz.getEnclosingClass() != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz != null && (clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz));
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return wrapperPrimitiveMap.containsKey(clazz);
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        if (clazz != null && clazz.isPrimitive()) {
            clazz2 = primitiveWrapperMap.get(clazz);
        }
        return clazz2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?>[] primitivesToWrappers(Class<?> ... classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) return classArray;
        Class[] classArray2 = new Class[classArray.length];
        int n2 = 0;
        while (n2 < classArray.length) {
            classArray2[n2] = ClassUtils.primitiveToWrapper(classArray[n2]);
            ++n2;
        }
        return classArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String toCanonicalName(String string2) {
        String string3 = StringUtils.deleteWhitespace(string2);
        if (string3 == null) {
            throw new NullPointerException("className must not be null.");
        }
        if (!string3.endsWith("[]")) return string3;
        StringBuilder stringBuilder = new StringBuilder();
        while (string3.endsWith("[]")) {
            string3 = string3.substring(0, -2 + string3.length());
            stringBuilder.append("[");
        }
        String string4 = abbreviationMap.get(string3);
        if (string4 != null) {
            stringBuilder.append(string4);
            return stringBuilder.toString();
        }
        stringBuilder.append("L").append(string3).append(";");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Class<?>[] toClass(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Class<?> clazz = objectArray[n2] == null ? null : objectArray[n2].getClass();
            classArray[n2] = clazz;
            ++n2;
        }
        return classArray;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        return wrapperPrimitiveMap.get(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?>[] wrappersToPrimitives(Class<?> ... classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) return classArray;
        Class[] classArray2 = new Class[classArray.length];
        int n2 = 0;
        while (n2 < classArray.length) {
            classArray2[n2] = ClassUtils.wrapperToPrimitive(classArray[n2]);
            ++n2;
        }
        return classArray2;
    }

    public static final class Interfaces
    extends Enum<Interfaces> {
        private static final /* synthetic */ Interfaces[] $VALUES;
        public static final /* enum */ Interfaces EXCLUDE;
        public static final /* enum */ Interfaces INCLUDE;

        static {
            INCLUDE = new Interfaces();
            EXCLUDE = new Interfaces();
            Interfaces[] interfacesArray = new Interfaces[]{INCLUDE, EXCLUDE};
            $VALUES = interfacesArray;
        }

        public static Interfaces valueOf(String string2) {
            return Enum.valueOf(Interfaces.class, string2);
        }

        public static Interfaces[] values() {
            return (Interfaces[])$VALUES.clone();
        }
    }
}

