/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;

public class CharUtils {
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    public static final char CR = '\r';
    public static final char LF = '\n';

    static {
        for (char c2 = '\u0000'; c2 < CHAR_STRING_ARRAY.length; c2 = (char)(c2 + '\u0001')) {
            CharUtils.CHAR_STRING_ARRAY[c2] = String.valueOf(c2);
        }
    }

    public static boolean isAscii(char c2) {
        return c2 < '\u0080';
    }

    public static boolean isAsciiAlpha(char c2) {
        return CharUtils.isAsciiAlphaUpper(c2) || CharUtils.isAsciiAlphaLower(c2);
    }

    public static boolean isAsciiAlphaLower(char c2) {
        return c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isAsciiAlphaUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static boolean isAsciiAlphanumeric(char c2) {
        return CharUtils.isAsciiAlpha(c2) || CharUtils.isAsciiNumeric(c2);
    }

    public static boolean isAsciiControl(char c2) {
        return c2 < ' ' || c2 == '\u007f';
    }

    public static boolean isAsciiNumeric(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isAsciiPrintable(char c2) {
        return c2 >= ' ' && c2 < '\u007f';
    }

    public static char toChar(Character c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("The Character must not be null");
        }
        return c2.charValue();
    }

    public static char toChar(Character c2, char c3) {
        if (c2 == null) {
            return c3;
        }
        return c2.charValue();
    }

    public static char toChar(String string2) {
        if (StringUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("The String must not be empty");
        }
        return string2.charAt(0);
    }

    public static char toChar(String string2, char c2) {
        if (StringUtils.isEmpty(string2)) {
            return c2;
        }
        return string2.charAt(0);
    }

    @Deprecated
    public static Character toCharacterObject(char c2) {
        return Character.valueOf(c2);
    }

    public static Character toCharacterObject(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return null;
        }
        return Character.valueOf(string2.charAt(0));
    }

    public static int toIntValue(char c2) {
        if (!CharUtils.isAsciiNumeric(c2)) {
            throw new IllegalArgumentException("The character " + c2 + " is not in the range '0' - '9'");
        }
        return c2 - 48;
    }

    public static int toIntValue(char c2, int n2) {
        if (!CharUtils.isAsciiNumeric(c2)) {
            return n2;
        }
        return c2 - 48;
    }

    public static int toIntValue(Character c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("The character must not be null");
        }
        return CharUtils.toIntValue(c2.charValue());
    }

    public static int toIntValue(Character c2, int n2) {
        if (c2 == null) {
            return n2;
        }
        return CharUtils.toIntValue(c2.charValue(), n2);
    }

    public static String toString(char c2) {
        if (c2 < '\u0080') {
            return CHAR_STRING_ARRAY[c2];
        }
        return new String(new char[]{c2});
    }

    public static String toString(Character c2) {
        if (c2 == null) {
            return null;
        }
        return CharUtils.toString(c2.charValue());
    }

    public static String unicodeEscaped(char c2) {
        if (c2 < '\u0010') {
            return "\\u000" + Integer.toHexString(c2);
        }
        if (c2 < '\u0100') {
            return "\\u00" + Integer.toHexString(c2);
        }
        if (c2 < '\u1000') {
            return "\\u0" + Integer.toHexString(c2);
        }
        return "\\u" + Integer.toHexString(c2);
    }

    public static String unicodeEscaped(Character c2) {
        if (c2 == null) {
            return null;
        }
        return CharUtils.unicodeEscaped(c2.charValue());
    }
}

