/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsAny(String string2, String ... stringArray) {
        if (!StringUtils.isEmpty(string2) && !CharSetUtils.deepEmpty(stringArray)) {
            CharSet charSet = CharSet.getInstance(stringArray);
            char[] cArray = string2.toCharArray();
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!charSet.contains(cArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int count(String string2, String ... stringArray) {
        if (StringUtils.isEmpty(string2)) return 0;
        if (CharSetUtils.deepEmpty(stringArray)) {
            return 0;
        }
        CharSet charSet = CharSet.getInstance(stringArray);
        int n2 = 0;
        char[] cArray = string2.toCharArray();
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (charSet.contains(cArray[n4])) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    private static boolean deepEmpty(String[] stringArray) {
        if (stringArray != null) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!StringUtils.isNotEmpty(stringArray[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public static String delete(String string2, String ... stringArray) {
        if (StringUtils.isEmpty(string2) || CharSetUtils.deepEmpty(stringArray)) {
            return string2;
        }
        return CharSetUtils.modify(string2, stringArray, false);
    }

    public static String keep(String string2, String ... stringArray) {
        if (string2 == null) {
            return null;
        }
        if (string2.isEmpty() || CharSetUtils.deepEmpty(stringArray)) {
            return "";
        }
        return CharSetUtils.modify(string2, stringArray, true);
    }

    private static String modify(String string2, String[] stringArray, boolean bl2) {
        CharSet charSet = CharSet.getInstance(stringArray);
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        char[] cArray = string2.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (charSet.contains(cArray[i2]) != bl2) continue;
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String squeeze(String string2, String ... stringArray) {
        if (StringUtils.isEmpty(string2) || CharSetUtils.deepEmpty(stringArray)) {
            return string2;
        }
        CharSet charSet = CharSet.getInstance(stringArray);
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        char[] cArray = string2.toCharArray();
        int n2 = cArray.length;
        char c2 = ' ';
        int n3 = 0;
        while (n3 < n2) {
            char c3 = cArray[n3];
            if (c3 != c2 || n3 == 0 || !charSet.contains(c3)) {
                stringBuilder.append(c3);
                c2 = c3;
            }
            ++n3;
        }
        return stringBuilder.toString();
    }
}

