/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.CharRange;

public class CharSet
implements Serializable {
    public static final CharSet ASCII_ALPHA;
    public static final CharSet ASCII_ALPHA_LOWER;
    public static final CharSet ASCII_ALPHA_UPPER;
    public static final CharSet ASCII_NUMERIC;
    protected static final Map<String, CharSet> COMMON;
    public static final CharSet EMPTY;
    private static final long serialVersionUID = 5947847346149275958L;
    private final Set<CharRange> set = Collections.synchronizedSet(new HashSet());

    static {
        String[] stringArray = new String[]{null};
        EMPTY = new CharSet(stringArray);
        ASCII_ALPHA = new CharSet("a-zA-Z");
        ASCII_ALPHA_LOWER = new CharSet("a-z");
        ASCII_ALPHA_UPPER = new CharSet("A-Z");
        ASCII_NUMERIC = new CharSet("0-9");
        COMMON = Collections.synchronizedMap(new HashMap());
        COMMON.put(null, EMPTY);
        COMMON.put("", EMPTY);
        COMMON.put("a-zA-Z", ASCII_ALPHA);
        COMMON.put("A-Za-z", ASCII_ALPHA);
        COMMON.put("a-z", ASCII_ALPHA_LOWER);
        COMMON.put("A-Z", ASCII_ALPHA_UPPER);
        COMMON.put("0-9", ASCII_NUMERIC);
    }

    protected CharSet(String ... stringArray) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(stringArray[i2]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CharSet getInstance(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length != 1) return new CharSet(stringArray);
        CharSet charSet = COMMON.get(stringArray[0]);
        if (charSet != null) return charSet;
        return new CharSet(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void add(String string2) {
        if (string2 != null) {
            int n2 = string2.length();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3;
                if (n4 >= 4 && string2.charAt(n3) == '^' && string2.charAt(n3 + 2) == '-') {
                    this.set.add(CharRange.isNotIn(string2.charAt(n3 + 1), string2.charAt(n3 + 3)));
                    n3 += 4;
                    continue;
                }
                if (n4 >= 3 && string2.charAt(n3 + 1) == '-') {
                    this.set.add(CharRange.isIn(string2.charAt(n3), string2.charAt(n3 + 2)));
                    n3 += 3;
                    continue;
                }
                if (n4 >= 2 && string2.charAt(n3) == '^') {
                    this.set.add(CharRange.isNot(string2.charAt(n3 + 1)));
                    n3 += 2;
                    continue;
                }
                this.set.add(CharRange.is(string2.charAt(n3)));
                ++n3;
            }
        }
    }

    public boolean contains(char c2) {
        Iterator<CharRange> iterator = this.set.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(c2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharSet)) {
            return false;
        }
        CharSet charSet = (CharSet)object;
        return this.set.equals(charSet.set);
    }

    CharRange[] getCharRanges() {
        return this.set.toArray(new CharRange[this.set.size()]);
    }

    public int hashCode() {
        return 89 + this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }
}

