/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class CharRange
implements Iterable<Character>,
Serializable {
    private static final long serialVersionUID = 8270183163158333422L;
    private final char end;
    private transient String iToString;
    private final boolean negated;
    private final char start;

    private CharRange(char c2, char c3, boolean bl2) {
        if (c2 > c3) {
            char c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        this.start = c2;
        this.end = c3;
        this.negated = bl2;
    }

    public static CharRange is(char c2) {
        return new CharRange(c2, c2, false);
    }

    public static CharRange isIn(char c2, char c3) {
        return new CharRange(c2, c3, false);
    }

    public static CharRange isNot(char c2) {
        return new CharRange(c2, c2, true);
    }

    public static CharRange isNotIn(char c2, char c3) {
        return new CharRange(c2, c3, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(char c2) {
        boolean bl2;
        if (c2 >= this.start && c2 <= this.end) {
            bl2 = true;
            return bl2 != this.negated;
        }
        bl2 = false;
        return bl2 != this.negated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(CharRange charRange) {
        if (charRange == null) {
            throw new IllegalArgumentException("The Range must not be null");
        }
        if (this.negated) {
            if (charRange.negated) {
                if (this.start < charRange.start) return false;
                if (this.end > charRange.end) return false;
                return true;
            }
            if (charRange.end < this.start) return true;
            char c2 = charRange.start;
            char c3 = this.end;
            boolean bl2 = false;
            if (c2 <= c3) return bl2;
            return true;
        }
        if (charRange.negated) {
            if (this.start != '\u0000') return false;
            if (this.end == '\uffff') return true;
            return false;
        }
        if (this.start > charRange.start) return false;
        if (this.end >= charRange.end) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof CharRange)) {
                    return false;
                }
                CharRange charRange = (CharRange)object;
                if (this.start != charRange.start || this.end != charRange.end || this.negated != charRange.negated) break block5;
            }
            return true;
        }
        return false;
    }

    public char getEnd() {
        return this.end;
    }

    public char getStart() {
        return this.start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n2;
        int n3 = 83 + this.start + 7 * this.end;
        if (this.negated) {
            n2 = 1;
            return n2 + n3;
        }
        n2 = 0;
        return n2 + n3;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharacterIterator(this);
    }

    public String toString() {
        if (this.iToString == null) {
            StringBuilder stringBuilder = new StringBuilder(4);
            if (this.isNegated()) {
                stringBuilder.append('^');
            }
            stringBuilder.append(this.start);
            if (this.start != this.end) {
                stringBuilder.append('-');
                stringBuilder.append(this.end);
            }
            this.iToString = stringBuilder.toString();
        }
        return this.iToString;
    }

    private static class CharacterIterator
    implements Iterator<Character> {
        private char current;
        private boolean hasNext;
        private final CharRange range;

        private CharacterIterator(CharRange charRange) {
            this.range = charRange;
            this.hasNext = true;
            if (this.range.negated) {
                if (this.range.start == '\u0000') {
                    if (this.range.end == '\uffff') {
                        this.hasNext = false;
                        return;
                    }
                    this.current = (char)('\u0001' + this.range.end);
                    return;
                }
                this.current = '\u0000';
                return;
            }
            this.current = this.range.start;
        }

        private void prepareNext() {
            if (this.range.negated) {
                if (this.current == '\uffff') {
                    this.hasNext = false;
                    return;
                }
                if ('\u0001' + this.current == this.range.start) {
                    if (this.range.end == '\uffff') {
                        this.hasNext = false;
                        return;
                    }
                    this.current = (char)('\u0001' + this.range.end);
                    return;
                }
                this.current = (char)('\u0001' + this.current);
                return;
            }
            if (this.current < this.range.end) {
                this.current = (char)('\u0001' + this.current);
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Character next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            char c2 = this.current;
            this.prepareNext();
            return Character.valueOf(c2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

