/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BooleanUtils {
    public static Boolean and(Boolean ... booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            if (BooleanUtils.and(ArrayUtils.toPrimitive(booleanArray))) {
                return Boolean.TRUE;
            }
            Boolean bl2 = Boolean.FALSE;
            return bl2;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean and(boolean ... blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (blArray[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFalse(Boolean bl2) {
        return Boolean.FALSE.equals(bl2);
    }

    public static boolean isNotFalse(Boolean bl2) {
        return !BooleanUtils.isFalse(bl2);
    }

    public static boolean isNotTrue(Boolean bl2) {
        return !BooleanUtils.isTrue(bl2);
    }

    public static boolean isTrue(Boolean bl2) {
        return Boolean.TRUE.equals(bl2);
    }

    public static Boolean negate(Boolean bl2) {
        if (bl2 == null) {
            return null;
        }
        if (bl2.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean or(Boolean ... booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            if (BooleanUtils.or(ArrayUtils.toPrimitive(booleanArray))) {
                return Boolean.TRUE;
            }
            Boolean bl2 = Boolean.FALSE;
            return bl2;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean or(boolean ... blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blArray[i2]) continue;
            return true;
        }
        return false;
    }

    public static boolean toBoolean(int n2) {
        return n2 != 0;
    }

    public static boolean toBoolean(int n2, int n3, int n4) {
        if (n2 == n3) {
            return true;
        }
        if (n2 == n4) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Boolean bl2) {
        return bl2 != null && bl2 != false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean toBoolean(Integer n2, Integer n3, Integer n4) {
        if (n2 == null) {
            if (n3 == null) return true;
            if (n4 != null) throw new IllegalArgumentException("The Integer did not match either specified value");
            return false;
        }
        if (n2.equals(n3)) {
            return true;
        }
        if (!n2.equals(n4)) throw new IllegalArgumentException("The Integer did not match either specified value");
        return false;
    }

    public static boolean toBoolean(String string2) {
        return BooleanUtils.toBooleanObject(string2) == Boolean.TRUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean toBoolean(String string2, String string3, String string4) {
        block6: {
            block7: {
                block5: {
                    if (string2 == string3) break block5;
                    if (string2 == string4) {
                        return false;
                    }
                    if (string2 == null) break block6;
                    if (!string2.equals(string3)) break block7;
                }
                return true;
            }
            if (string2.equals(string4)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static boolean toBooleanDefaultIfNull(Boolean bl2, boolean bl3) {
        if (bl2 == null) {
            return bl3;
        }
        return bl2;
    }

    public static Boolean toBooleanObject(int n2) {
        if (n2 == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean toBooleanObject(int n2, int n3, int n4, int n5) {
        if (n2 == n3) {
            return Boolean.TRUE;
        }
        if (n2 == n4) {
            return Boolean.FALSE;
        }
        if (n2 == n5) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer n2) {
        if (n2 == null) {
            return null;
        }
        if (n2 == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean toBooleanObject(Integer n2, Integer n3, Integer n4, Integer n5) {
        if (n2 == null) {
            if (n3 == null) {
                return Boolean.TRUE;
            }
            if (n4 == null) {
                return Boolean.FALSE;
            }
            Boolean bl2 = null;
            if (n5 == null) return bl2;
            throw new IllegalArgumentException("The Integer did not match any specified value");
        }
        if (n2.equals(n3)) {
            return Boolean.TRUE;
        }
        if (n2.equals(n4)) {
            return Boolean.FALSE;
        }
        if (!n2.equals(n5)) throw new IllegalArgumentException("The Integer did not match any specified value");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Boolean toBooleanObject(String string2) {
        if (string2 == "true") {
            return Boolean.TRUE;
        }
        if (string2 == null) {
            return null;
        }
        switch (string2.length()) {
            case 1: {
                char c2 = string2.charAt(0);
                if (c2 == 'y' || c2 == 'Y' || c2 == 't' || c2 == 'T') {
                    return Boolean.TRUE;
                }
                if (c2 != 'n' && c2 != 'N' && c2 != 'f' && c2 != 'F') return null;
                return Boolean.FALSE;
            }
            case 2: {
                char c3 = string2.charAt(0);
                char c4 = string2.charAt(1);
                if (!(c3 != 'o' && c3 != 'O' || c4 != 'n' && c4 != 'N')) {
                    return Boolean.TRUE;
                }
                if (c3 != 'n' && c3 != 'N' || c4 != 'o' && c4 != 'O') return null;
                return Boolean.FALSE;
            }
            case 3: {
                char c5 = string2.charAt(0);
                char c6 = string2.charAt(1);
                char c7 = string2.charAt(2);
                if (!(c5 != 'y' && c5 != 'Y' || c6 != 'e' && c6 != 'E' || c7 != 's' && c7 != 'S')) {
                    return Boolean.TRUE;
                }
                if (c5 != 'o' && c5 != 'O' || c6 != 'f' && c6 != 'F' || c7 != 'f' && c7 != 'F') return null;
                return Boolean.FALSE;
            }
            case 4: {
                char c8 = string2.charAt(0);
                char c9 = string2.charAt(1);
                char c10 = string2.charAt(2);
                char c11 = string2.charAt(3);
                if (c8 != 't' && c8 != 'T' || c9 != 'r' && c9 != 'R' || c10 != 'u' && c10 != 'U' || c11 != 'e' && c11 != 'E') return null;
                return Boolean.TRUE;
            }
            default: {
                return null;
            }
            case 5: 
        }
        char c12 = string2.charAt(0);
        char c13 = string2.charAt(1);
        char c14 = string2.charAt(2);
        char c15 = string2.charAt(3);
        char c16 = string2.charAt(4);
        if (c12 != 'f' && c12 != 'F' || c13 != 'a' && c13 != 'A' || c14 != 'l' && c14 != 'L' || c15 != 's' && c15 != 'S' || c16 != 'e' && c16 != 'E') return null;
        return Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean toBooleanObject(String string2, String string3, String string4, String string5) {
        if (string2 == null) {
            if (string3 == null) {
                return Boolean.TRUE;
            }
            if (string4 == null) {
                return Boolean.FALSE;
            }
            Boolean bl2 = null;
            if (string5 == null) return bl2;
            throw new IllegalArgumentException("The String did not match any specified value");
        }
        if (string2.equals(string3)) {
            return Boolean.TRUE;
        }
        if (string2.equals(string4)) {
            return Boolean.FALSE;
        }
        if (!string2.equals(string5)) throw new IllegalArgumentException("The String did not match any specified value");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int toInteger(Boolean bl2, int n2, int n3, int n4) {
        if (bl2 == null) {
            return n4;
        }
        if (bl2 == false) return n3;
        return n2;
    }

    public static int toInteger(boolean bl2) {
        if (bl2) {
            return 1;
        }
        return 0;
    }

    public static int toInteger(boolean bl2, int n2, int n3) {
        if (bl2) {
            return n2;
        }
        return n3;
    }

    public static Integer toIntegerObject(Boolean bl2) {
        if (bl2 == null) {
            return null;
        }
        if (bl2.booleanValue()) {
            return NumberUtils.INTEGER_ONE;
        }
        return NumberUtils.INTEGER_ZERO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Integer toIntegerObject(Boolean bl2, Integer n2, Integer n3, Integer n4) {
        if (bl2 == null) {
            return n4;
        }
        if (bl2 == false) return n3;
        return n2;
    }

    public static Integer toIntegerObject(boolean bl2) {
        if (bl2) {
            return NumberUtils.INTEGER_ONE;
        }
        return NumberUtils.INTEGER_ZERO;
    }

    public static Integer toIntegerObject(boolean bl2, Integer n2, Integer n3) {
        if (bl2) {
            return n2;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(Boolean bl2, String string2, String string3, String string4) {
        if (bl2 == null) {
            return string4;
        }
        if (bl2 == false) return string3;
        return string2;
    }

    public static String toString(boolean bl2, String string2, String string3) {
        if (bl2) {
            return string2;
        }
        return string3;
    }

    public static String toStringOnOff(Boolean bl2) {
        return BooleanUtils.toString(bl2, "on", "off", null);
    }

    public static String toStringOnOff(boolean bl2) {
        return BooleanUtils.toString(bl2, "on", "off");
    }

    public static String toStringTrueFalse(Boolean bl2) {
        return BooleanUtils.toString(bl2, "true", "false", null);
    }

    public static String toStringTrueFalse(boolean bl2) {
        return BooleanUtils.toString(bl2, "true", "false");
    }

    public static String toStringYesNo(Boolean bl2) {
        return BooleanUtils.toString(bl2, "yes", "no", null);
    }

    public static String toStringYesNo(boolean bl2) {
        return BooleanUtils.toString(bl2, "yes", "no");
    }

    public static Boolean xor(Boolean ... booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            if (BooleanUtils.xor(ArrayUtils.toPrimitive(booleanArray))) {
                return Boolean.TRUE;
            }
            Boolean bl2 = Boolean.FALSE;
            return bl2;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean xor(boolean ... blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean bl2 = false;
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            bl2 ^= blArray[i2];
        }
        return bl2;
    }
}

