/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY;
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY;
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY;
    public static final Class<?>[] EMPTY_CLASS_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY;
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY;
    public static final float[] EMPTY_FLOAT_ARRAY;
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY;
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY;
    public static final int[] EMPTY_INT_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY;
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final short[] EMPTY_SHORT_ARRAY;
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final int INDEX_NOT_FOUND = -1;

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_LONG_OBJECT_ARRAY = new Long[0];
        EMPTY_INT_ARRAY = new int[0];
        EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
        EMPTY_SHORT_ARRAY = new short[0];
        EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
        EMPTY_DOUBLE_ARRAY = new double[0];
        EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
        EMPTY_FLOAT_ARRAY = new float[0];
        EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
        EMPTY_BOOLEAN_ARRAY = new boolean[0];
        EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
        EMPTY_CHAR_ARRAY = new char[0];
        EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    }

    private static Object add(Object object, int n2, Object object2, Class<?> clazz) {
        if (object == null) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: 0");
            }
            Object object3 = Array.newInstance(clazz, 1);
            Array.set(object3, 0, object2);
            return object3;
        }
        int n3 = Array.getLength(object);
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: " + n3);
        }
        Object object4 = Array.newInstance(clazz, n3 + 1);
        System.arraycopy(object, 0, object4, 0, n2);
        Array.set(object4, n2, object2);
        if (n2 < n3) {
            System.arraycopy(object, n2, object4, n2 + 1, n3 - n2);
        }
        return object4;
    }

    public static byte[] add(byte[] byArray, byte by2) {
        byte[] byArray2 = (byte[])ArrayUtils.copyArrayGrow1(byArray, Byte.TYPE);
        byArray2[-1 + byArray2.length] = by2;
        return byArray2;
    }

    public static byte[] add(byte[] byArray, int n2, byte by2) {
        return (byte[])ArrayUtils.add(byArray, n2, by2, Byte.TYPE);
    }

    public static char[] add(char[] cArray, char c2) {
        char[] cArray2 = (char[])ArrayUtils.copyArrayGrow1(cArray, Character.TYPE);
        cArray2[-1 + cArray2.length] = c2;
        return cArray2;
    }

    public static char[] add(char[] cArray, int n2, char c2) {
        return (char[])ArrayUtils.add(cArray, n2, Character.valueOf(c2), Character.TYPE);
    }

    public static double[] add(double[] dArray, double d2) {
        double[] dArray2 = (double[])ArrayUtils.copyArrayGrow1(dArray, Double.TYPE);
        dArray2[-1 + dArray2.length] = d2;
        return dArray2;
    }

    public static double[] add(double[] dArray, int n2, double d2) {
        return (double[])ArrayUtils.add(dArray, n2, d2, Double.TYPE);
    }

    public static float[] add(float[] fArray, float f2) {
        float[] fArray2 = (float[])ArrayUtils.copyArrayGrow1(fArray, Float.TYPE);
        fArray2[-1 + fArray2.length] = f2;
        return fArray2;
    }

    public static float[] add(float[] fArray, int n2, float f2) {
        return (float[])ArrayUtils.add(fArray, n2, Float.valueOf(f2), Float.TYPE);
    }

    public static int[] add(int[] nArray, int n2) {
        int[] nArray2 = (int[])ArrayUtils.copyArrayGrow1(nArray, Integer.TYPE);
        nArray2[-1 + nArray2.length] = n2;
        return nArray2;
    }

    public static int[] add(int[] nArray, int n2, int n3) {
        return (int[])ArrayUtils.add(nArray, n2, n3, Integer.TYPE);
    }

    public static long[] add(long[] lArray, int n2, long l2) {
        return (long[])ArrayUtils.add(lArray, n2, l2, Long.TYPE);
    }

    public static long[] add(long[] lArray, long l2) {
        long[] lArray2 = (long[])ArrayUtils.copyArrayGrow1(lArray, Long.TYPE);
        lArray2[-1 + lArray2.length] = l2;
        return lArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T[] add(T[] TArray, int n2, T t2) {
        Class<?> clazz;
        if (TArray != null) {
            clazz = TArray.getClass().getComponentType();
            return (Object[])ArrayUtils.add(TArray, n2, t2, clazz);
        }
        if (t2 == null) throw new IllegalArgumentException("Array and element cannot both be null");
        clazz = t2.getClass();
        return (Object[])ArrayUtils.add(TArray, n2, t2, clazz);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T[] add(T[] TArray, T t2) {
        Class<?> clazz;
        if (TArray != null) {
            clazz = TArray.getClass();
        } else {
            if (t2 == null) {
                throw new IllegalArgumentException("Arguments cannot both be null");
            }
            clazz = t2.getClass();
        }
        Object[] objectArray = (Object[])ArrayUtils.copyArrayGrow1(TArray, clazz);
        objectArray[-1 + objectArray.length] = t2;
        return objectArray;
    }

    public static short[] add(short[] sArray, int n2, short s2) {
        return (short[])ArrayUtils.add(sArray, n2, s2, Short.TYPE);
    }

    public static short[] add(short[] sArray, short s2) {
        short[] sArray2 = (short[])ArrayUtils.copyArrayGrow1(sArray, Short.TYPE);
        sArray2[-1 + sArray2.length] = s2;
        return sArray2;
    }

    public static boolean[] add(boolean[] blArray, int n2, boolean bl2) {
        return (boolean[])ArrayUtils.add(blArray, n2, bl2, Boolean.TYPE);
    }

    public static boolean[] add(boolean[] blArray, boolean bl2) {
        boolean[] blArray2 = (boolean[])ArrayUtils.copyArrayGrow1(blArray, Boolean.TYPE);
        blArray2[-1 + blArray2.length] = bl2;
        return blArray2;
    }

    public static byte[] addAll(byte[] byArray, byte ... byArray2) {
        if (byArray == null) {
            return ArrayUtils.clone(byArray2);
        }
        if (byArray2 == null) {
            return ArrayUtils.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static char[] addAll(char[] cArray, char ... cArray2) {
        if (cArray == null) {
            return ArrayUtils.clone(cArray2);
        }
        if (cArray2 == null) {
            return ArrayUtils.clone(cArray);
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static double[] addAll(double[] dArray, double ... dArray2) {
        if (dArray == null) {
            return ArrayUtils.clone(dArray2);
        }
        if (dArray2 == null) {
            return ArrayUtils.clone(dArray);
        }
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public static float[] addAll(float[] fArray, float ... fArray2) {
        if (fArray == null) {
            return ArrayUtils.clone(fArray2);
        }
        if (fArray2 == null) {
            return ArrayUtils.clone(fArray);
        }
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    public static int[] addAll(int[] nArray, int ... nArray2) {
        if (nArray == null) {
            return ArrayUtils.clone(nArray2);
        }
        if (nArray2 == null) {
            return ArrayUtils.clone(nArray);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static long[] addAll(long[] lArray, long ... lArray2) {
        if (lArray == null) {
            return ArrayUtils.clone(lArray2);
        }
        if (lArray2 == null) {
            return ArrayUtils.clone(lArray);
        }
        long[] lArray3 = new long[lArray.length + lArray2.length];
        System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
        System.arraycopy(lArray2, 0, lArray3, lArray.length, lArray2.length);
        return lArray3;
    }

    public static <T> T[] addAll(T[] TArray, T ... TArray2) {
        if (TArray == null) {
            return ArrayUtils.clone(TArray2);
        }
        if (TArray2 == null) {
            return ArrayUtils.clone(TArray);
        }
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        try {
            System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
            return objectArray;
        }
        catch (ArrayStoreException arrayStoreException) {
            Class<?> clazz2 = TArray2.getClass().getComponentType();
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Cannot store " + clazz2.getName() + " in an array of " + clazz.getName(), arrayStoreException);
            }
            throw arrayStoreException;
        }
    }

    public static short[] addAll(short[] sArray, short ... sArray2) {
        if (sArray == null) {
            return ArrayUtils.clone(sArray2);
        }
        if (sArray2 == null) {
            return ArrayUtils.clone(sArray);
        }
        short[] sArray3 = new short[sArray.length + sArray2.length];
        System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
        System.arraycopy(sArray2, 0, sArray3, sArray.length, sArray2.length);
        return sArray3;
    }

    public static boolean[] addAll(boolean[] blArray, boolean ... blArray2) {
        if (blArray == null) {
            return ArrayUtils.clone(blArray2);
        }
        if (blArray2 == null) {
            return ArrayUtils.clone(blArray);
        }
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return (byte[])byArray.clone();
    }

    public static char[] clone(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return (char[])cArray.clone();
    }

    public static double[] clone(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        return (double[])dArray.clone();
    }

    public static float[] clone(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        return (float[])fArray.clone();
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        return (int[])nArray.clone();
    }

    public static long[] clone(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        return (long[])lArray.clone();
    }

    public static <T> T[] clone(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        return (Object[])TArray.clone();
    }

    public static short[] clone(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        return (short[])sArray.clone();
    }

    public static boolean[] clone(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        return (boolean[])blArray.clone();
    }

    public static boolean contains(byte[] byArray, byte by2) {
        return ArrayUtils.indexOf(byArray, by2) != -1;
    }

    public static boolean contains(char[] cArray, char c2) {
        return ArrayUtils.indexOf(cArray, c2) != -1;
    }

    public static boolean contains(double[] dArray, double d2) {
        return ArrayUtils.indexOf(dArray, d2) != -1;
    }

    public static boolean contains(double[] dArray, double d2, double d3) {
        int n2 = ArrayUtils.indexOf(dArray, d2, 0, d3);
        boolean bl2 = false;
        if (n2 != -1) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean contains(float[] fArray, float f2) {
        return ArrayUtils.indexOf(fArray, f2) != -1;
    }

    public static boolean contains(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2) != -1;
    }

    public static boolean contains(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2) != -1;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object) != -1;
    }

    public static boolean contains(short[] sArray, short s2) {
        return ArrayUtils.indexOf(sArray, s2) != -1;
    }

    public static boolean contains(boolean[] blArray, boolean bl2) {
        return ArrayUtils.indexOf(blArray, bl2) != -1;
    }

    private static Object copyArrayGrow1(Object object, Class<?> clazz) {
        if (object != null) {
            int n2 = Array.getLength(object);
            Object object2 = Array.newInstance(object.getClass().getComponentType(), n2 + 1);
            System.arraycopy(object, 0, object2, 0, n2);
            return object2;
        }
        return Array.newInstance(clazz, 1);
    }

    public static int getLength(Object object) {
        if (object == null) {
            return 0;
        }
        return Array.getLength(object);
    }

    public static int hashCode(Object object) {
        return new HashCodeBuilder().append(object).toHashCode();
    }

    public static int indexOf(byte[] byArray, byte by2) {
        return ArrayUtils.indexOf(byArray, by2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(byte[] byArray, byte by2, int n2) {
        if (byArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < byArray.length) {
            if (by2 == byArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, char c2) {
        return ArrayUtils.indexOf(cArray, c2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(char[] cArray, char c2, int n2) {
        if (cArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < cArray.length) {
            if (c2 == cArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double d2) {
        return ArrayUtils.indexOf(dArray, d2, 0);
    }

    public static int indexOf(double[] dArray, double d2, double d3) {
        return ArrayUtils.indexOf(dArray, d2, 0, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(double[] dArray, double d2, int n2) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < dArray.length) {
            if (d2 == dArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(double[] dArray, double d2, int n2, double d3) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        double d4 = d2 - d3;
        double d5 = d2 + d3;
        int n3 = n2;
        while (n3 < dArray.length) {
            if (dArray[n3] >= d4) {
                if (dArray[n3] <= d5) return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int indexOf(float[] fArray, float f2) {
        return ArrayUtils.indexOf(fArray, f2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(float[] fArray, float f2, int n2) {
        if (ArrayUtils.isEmpty(fArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < fArray.length) {
            if (f2 == fArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = n3;
        while (n4 < nArray.length) {
            if (n2 == nArray[n4]) return n4;
            ++n4;
        }
        return -1;
    }

    public static int indexOf(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(long[] lArray, long l2, int n2) {
        if (lArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < lArray.length) {
            if (l2 == lArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(Object[] objectArray, Object object, int n2) {
        int n3;
        if (objectArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (object == null) {
            n3 = n2;
            while (n3 < objectArray.length) {
                if (objectArray[n3] == null) return n3;
                ++n3;
            }
            return -1;
        }
        if (!objectArray.getClass().getComponentType().isInstance(object)) return -1;
        n3 = n2;
        while (n3 < objectArray.length) {
            if (object.equals(objectArray[n3])) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(short[] sArray, short s2) {
        return ArrayUtils.indexOf(sArray, s2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(short[] sArray, short s2, int n2) {
        if (sArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < sArray.length) {
            if (s2 == sArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOf(boolean[] blArray, boolean bl2) {
        return ArrayUtils.indexOf(blArray, bl2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(boolean[] blArray, boolean bl2, int n2) {
        if (ArrayUtils.isEmpty(blArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < blArray.length) {
            if (bl2 == blArray[n3]) return n3;
            ++n3;
        }
        return -1;
    }

    public static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    public static boolean isEmpty(char[] cArray) {
        return cArray == null || cArray.length == 0;
    }

    public static boolean isEmpty(double[] dArray) {
        return dArray == null || dArray.length == 0;
    }

    public static boolean isEmpty(float[] fArray) {
        return fArray == null || fArray.length == 0;
    }

    public static boolean isEmpty(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    public static boolean isEmpty(long[] lArray) {
        return lArray == null || lArray.length == 0;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(short[] sArray) {
        return sArray == null || sArray.length == 0;
    }

    public static boolean isEmpty(boolean[] blArray) {
        return blArray == null || blArray.length == 0;
    }

    @Deprecated
    public static boolean isEquals(Object object, Object object2) {
        return new EqualsBuilder().append(object, object2).isEquals();
    }

    public static boolean isNotEmpty(byte[] byArray) {
        return byArray != null && byArray.length != 0;
    }

    public static boolean isNotEmpty(char[] cArray) {
        return cArray != null && cArray.length != 0;
    }

    public static boolean isNotEmpty(double[] dArray) {
        return dArray != null && dArray.length != 0;
    }

    public static boolean isNotEmpty(float[] fArray) {
        return fArray != null && fArray.length != 0;
    }

    public static boolean isNotEmpty(int[] nArray) {
        return nArray != null && nArray.length != 0;
    }

    public static boolean isNotEmpty(long[] lArray) {
        return lArray != null && lArray.length != 0;
    }

    public static <T> boolean isNotEmpty(T[] TArray) {
        return TArray != null && TArray.length != 0;
    }

    public static boolean isNotEmpty(short[] sArray) {
        return sArray != null && sArray.length != 0;
    }

    public static boolean isNotEmpty(boolean[] blArray) {
        return blArray != null && blArray.length != 0;
    }

    public static boolean isSameLength(byte[] byArray, byte[] byArray2) {
        return !(byArray == null && byArray2 != null && byArray2.length > 0 || byArray2 == null && byArray != null && byArray.length > 0) && (byArray == null || byArray2 == null || byArray.length == byArray2.length);
    }

    public static boolean isSameLength(char[] cArray, char[] cArray2) {
        return !(cArray == null && cArray2 != null && cArray2.length > 0 || cArray2 == null && cArray != null && cArray.length > 0) && (cArray == null || cArray2 == null || cArray.length == cArray2.length);
    }

    public static boolean isSameLength(double[] dArray, double[] dArray2) {
        return !(dArray == null && dArray2 != null && dArray2.length > 0 || dArray2 == null && dArray != null && dArray.length > 0) && (dArray == null || dArray2 == null || dArray.length == dArray2.length);
    }

    public static boolean isSameLength(float[] fArray, float[] fArray2) {
        return !(fArray == null && fArray2 != null && fArray2.length > 0 || fArray2 == null && fArray != null && fArray.length > 0) && (fArray == null || fArray2 == null || fArray.length == fArray2.length);
    }

    public static boolean isSameLength(int[] nArray, int[] nArray2) {
        return !(nArray == null && nArray2 != null && nArray2.length > 0 || nArray2 == null && nArray != null && nArray.length > 0) && (nArray == null || nArray2 == null || nArray.length == nArray2.length);
    }

    public static boolean isSameLength(long[] lArray, long[] lArray2) {
        return !(lArray == null && lArray2 != null && lArray2.length > 0 || lArray2 == null && lArray != null && lArray.length > 0) && (lArray == null || lArray2 == null || lArray.length == lArray2.length);
    }

    public static boolean isSameLength(Object[] objectArray, Object[] objectArray2) {
        return !(objectArray == null && objectArray2 != null && objectArray2.length > 0 || objectArray2 == null && objectArray != null && objectArray.length > 0) && (objectArray == null || objectArray2 == null || objectArray.length == objectArray2.length);
    }

    public static boolean isSameLength(short[] sArray, short[] sArray2) {
        return !(sArray == null && sArray2 != null && sArray2.length > 0 || sArray2 == null && sArray != null && sArray.length > 0) && (sArray == null || sArray2 == null || sArray.length == sArray2.length);
    }

    public static boolean isSameLength(boolean[] blArray, boolean[] blArray2) {
        return !(blArray == null && blArray2 != null && blArray2.length > 0 || blArray2 == null && blArray != null && blArray.length > 0) && (blArray == null || blArray2 == null || blArray.length == blArray2.length);
    }

    public static boolean isSameType(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return object.getClass().getName().equals(object2.getClass().getName());
    }

    public static int lastIndexOf(byte[] byArray, byte by2) {
        return ArrayUtils.lastIndexOf(byArray, by2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(byte[] byArray, byte by2, int n2) {
        if (byArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= byArray.length) {
            n2 = -1 + byArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (by2 == byArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c2) {
        return ArrayUtils.lastIndexOf(cArray, c2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(char[] cArray, char c2, int n2) {
        if (cArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= cArray.length) {
            n2 = -1 + cArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (c2 == cArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d2) {
        return ArrayUtils.lastIndexOf(dArray, d2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] dArray, double d2, double d3) {
        return ArrayUtils.lastIndexOf(dArray, d2, Integer.MAX_VALUE, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(double[] dArray, double d2, int n2) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= dArray.length) {
            n2 = -1 + dArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (d2 == dArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(double[] dArray, double d2, int n2, double d3) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= dArray.length) {
            n2 = -1 + dArray.length;
        }
        double d4 = d2 - d3;
        double d5 = d2 + d3;
        int n3 = n2;
        while (n3 >= 0) {
            if (dArray[n3] >= d4) {
                if (dArray[n3] <= d5) return n3;
            }
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(float[] fArray, float f2) {
        return ArrayUtils.lastIndexOf(fArray, f2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(float[] fArray, float f2, int n2) {
        if (ArrayUtils.isEmpty(fArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= fArray.length) {
            n2 = -1 + fArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (f2 == fArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n2) {
        return ArrayUtils.lastIndexOf(nArray, n2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return -1;
        }
        if (n3 < 0) {
            return -1;
        }
        if (n3 >= nArray.length) {
            n3 = -1 + nArray.length;
        }
        int n4 = n3;
        while (n4 >= 0) {
            if (n2 == nArray[n4]) return n4;
            --n4;
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l2) {
        return ArrayUtils.lastIndexOf(lArray, l2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(long[] lArray, long l2, int n2) {
        if (lArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= lArray.length) {
            n2 = -1 + lArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (l2 == lArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] objectArray, Object object) {
        return ArrayUtils.lastIndexOf(objectArray, object, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(Object[] objectArray, Object object, int n2) {
        int n3;
        if (objectArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= objectArray.length) {
            n2 = -1 + objectArray.length;
        }
        if (object == null) {
            n3 = n2;
            while (n3 >= 0) {
                if (objectArray[n3] == null) return n3;
                --n3;
            }
            return -1;
        }
        if (!objectArray.getClass().getComponentType().isInstance(object)) return -1;
        n3 = n2;
        while (n3 >= 0) {
            if (object.equals(objectArray[n3])) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        return ArrayUtils.lastIndexOf(sArray, s2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(short[] sArray, short s2, int n2) {
        if (sArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= sArray.length) {
            n2 = -1 + sArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (s2 == sArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl2) {
        return ArrayUtils.lastIndexOf(blArray, bl2, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(boolean[] blArray, boolean bl2, int n2) {
        if (ArrayUtils.isEmpty(blArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= blArray.length) {
            n2 = -1 + blArray.length;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (bl2 == blArray[n3]) return n3;
            --n3;
        }
        return -1;
    }

    public static byte[] nullToEmpty(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            byArray = EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static char[] nullToEmpty(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            cArray = EMPTY_CHAR_ARRAY;
        }
        return cArray;
    }

    public static double[] nullToEmpty(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            dArray = EMPTY_DOUBLE_ARRAY;
        }
        return dArray;
    }

    public static float[] nullToEmpty(float[] fArray) {
        if (fArray == null || fArray.length == 0) {
            fArray = EMPTY_FLOAT_ARRAY;
        }
        return fArray;
    }

    public static int[] nullToEmpty(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = EMPTY_INT_ARRAY;
        }
        return nArray;
    }

    public static long[] nullToEmpty(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            lArray = EMPTY_LONG_ARRAY;
        }
        return lArray;
    }

    public static Boolean[] nullToEmpty(Boolean[] booleanArray) {
        if (booleanArray == null || booleanArray.length == 0) {
            booleanArray = EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return booleanArray;
    }

    public static Byte[] nullToEmpty(Byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            byteArray = EMPTY_BYTE_OBJECT_ARRAY;
        }
        return byteArray;
    }

    public static Character[] nullToEmpty(Character[] characterArray) {
        if (characterArray == null || characterArray.length == 0) {
            characterArray = EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return characterArray;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            classArray = EMPTY_CLASS_ARRAY;
        }
        return classArray;
    }

    public static Double[] nullToEmpty(Double[] doubleArray) {
        if (doubleArray == null || doubleArray.length == 0) {
            doubleArray = EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return doubleArray;
    }

    public static Float[] nullToEmpty(Float[] floatArray) {
        if (floatArray == null || floatArray.length == 0) {
            floatArray = EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return floatArray;
    }

    public static Integer[] nullToEmpty(Integer[] integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            integerArray = EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return integerArray;
    }

    public static Long[] nullToEmpty(Long[] longArray) {
        if (longArray == null || longArray.length == 0) {
            longArray = EMPTY_LONG_OBJECT_ARRAY;
        }
        return longArray;
    }

    public static Object[] nullToEmpty(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        return objectArray;
    }

    public static Short[] nullToEmpty(Short[] shortArray) {
        if (shortArray == null || shortArray.length == 0) {
            shortArray = EMPTY_SHORT_OBJECT_ARRAY;
        }
        return shortArray;
    }

    public static String[] nullToEmpty(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    public static short[] nullToEmpty(short[] sArray) {
        if (sArray == null || sArray.length == 0) {
            sArray = EMPTY_SHORT_ARRAY;
        }
        return sArray;
    }

    public static boolean[] nullToEmpty(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            blArray = EMPTY_BOOLEAN_ARRAY;
        }
        return blArray;
    }

    private static Object remove(Object object, int n2) {
        int n3 = ArrayUtils.getLength(object);
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: " + n3);
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n3 - 1);
        System.arraycopy(object, 0, object2, 0, n2);
        if (n2 < n3 - 1) {
            System.arraycopy(object, n2 + 1, object2, n2, -1 + (n3 - n2));
        }
        return object2;
    }

    public static byte[] remove(byte[] byArray, int n2) {
        return (byte[])ArrayUtils.remove((Object)byArray, n2);
    }

    public static char[] remove(char[] cArray, int n2) {
        return (char[])ArrayUtils.remove((Object)cArray, n2);
    }

    public static double[] remove(double[] dArray, int n2) {
        return (double[])ArrayUtils.remove((Object)dArray, n2);
    }

    public static float[] remove(float[] fArray, int n2) {
        return (float[])ArrayUtils.remove((Object)fArray, n2);
    }

    public static int[] remove(int[] nArray, int n2) {
        return (int[])ArrayUtils.remove((Object)nArray, n2);
    }

    public static long[] remove(long[] lArray, int n2) {
        return (long[])ArrayUtils.remove((Object)lArray, n2);
    }

    public static <T> T[] remove(T[] TArray, int n2) {
        return (Object[])ArrayUtils.remove(TArray, n2);
    }

    public static short[] remove(short[] sArray, int n2) {
        return (short[])ArrayUtils.remove((Object)sArray, n2);
    }

    public static boolean[] remove(boolean[] blArray, int n2) {
        return (boolean[])ArrayUtils.remove((Object)blArray, n2);
    }

    static Object removeAll(Object object, BitSet bitSet) {
        int n2;
        int n3 = ArrayUtils.getLength(object);
        int n4 = bitSet.cardinality();
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n3 - n4);
        int n5 = 0;
        int n6 = 0;
        while ((n2 = bitSet.nextSetBit(n5)) != -1) {
            int n7 = n2 - n5;
            if (n7 > 0) {
                System.arraycopy(object, n5, object2, n6, n7);
                n6 += n7;
            }
            n5 = bitSet.nextClearBit(n2);
        }
        int n8 = n3 - n5;
        if (n8 > 0) {
            System.arraycopy(object, n5, object2, n6, n8);
        }
        return object2;
    }

    static Object removeAll(Object object, int ... nArray) {
        int n2 = ArrayUtils.getLength(object);
        boolean bl2 = ArrayUtils.isNotEmpty(nArray);
        int n3 = 0;
        if (bl2) {
            Arrays.sort(nArray);
            int n4 = nArray.length;
            int n5 = n2;
            while (--n4 >= 0) {
                int n6 = nArray[n4];
                if (n6 < 0 || n6 >= n2) {
                    throw new IndexOutOfBoundsException("Index: " + n6 + ", Length: " + n2);
                }
                if (n6 >= n5) continue;
                ++n3;
                n5 = n6;
            }
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2 - n3);
        if (n3 < n2) {
            int n7 = n2;
            int n8 = n2 - n3;
            for (int i2 = -1 + nArray.length; i2 >= 0; --i2) {
                int n9 = nArray[i2];
                if (n7 - n9 > 1) {
                    int n10 = -1 + (n7 - n9);
                    System.arraycopy(object, n9 + 1, object2, n8 -= n10, n10);
                }
                n7 = n9;
            }
            if (n7 > 0) {
                System.arraycopy(object, 0, object2, 0, n7);
            }
        }
        return object2;
    }

    public static byte[] removeAll(byte[] byArray, int ... nArray) {
        return (byte[])ArrayUtils.removeAll((Object)byArray, ArrayUtils.clone(nArray));
    }

    public static char[] removeAll(char[] cArray, int ... nArray) {
        return (char[])ArrayUtils.removeAll((Object)cArray, ArrayUtils.clone(nArray));
    }

    public static double[] removeAll(double[] dArray, int ... nArray) {
        return (double[])ArrayUtils.removeAll((Object)dArray, ArrayUtils.clone(nArray));
    }

    public static float[] removeAll(float[] fArray, int ... nArray) {
        return (float[])ArrayUtils.removeAll((Object)fArray, ArrayUtils.clone(nArray));
    }

    public static int[] removeAll(int[] nArray, int ... nArray2) {
        return (int[])ArrayUtils.removeAll((Object)nArray, ArrayUtils.clone(nArray2));
    }

    public static long[] removeAll(long[] lArray, int ... nArray) {
        return (long[])ArrayUtils.removeAll((Object)lArray, ArrayUtils.clone(nArray));
    }

    public static <T> T[] removeAll(T[] TArray, int ... nArray) {
        return (Object[])ArrayUtils.removeAll(TArray, ArrayUtils.clone(nArray));
    }

    public static short[] removeAll(short[] sArray, int ... nArray) {
        return (short[])ArrayUtils.removeAll((Object)sArray, ArrayUtils.clone(nArray));
    }

    public static boolean[] removeAll(boolean[] blArray, int ... nArray) {
        return (boolean[])ArrayUtils.removeAll((Object)blArray, ArrayUtils.clone(nArray));
    }

    public static byte[] removeElement(byte[] byArray, byte by2) {
        int n2 = ArrayUtils.indexOf(byArray, by2);
        if (n2 == -1) {
            return ArrayUtils.clone(byArray);
        }
        return ArrayUtils.remove(byArray, n2);
    }

    public static char[] removeElement(char[] cArray, char c2) {
        int n2 = ArrayUtils.indexOf(cArray, c2);
        if (n2 == -1) {
            return ArrayUtils.clone(cArray);
        }
        return ArrayUtils.remove(cArray, n2);
    }

    public static double[] removeElement(double[] dArray, double d2) {
        int n2 = ArrayUtils.indexOf(dArray, d2);
        if (n2 == -1) {
            return ArrayUtils.clone(dArray);
        }
        return ArrayUtils.remove(dArray, n2);
    }

    public static float[] removeElement(float[] fArray, float f2) {
        int n2 = ArrayUtils.indexOf(fArray, f2);
        if (n2 == -1) {
            return ArrayUtils.clone(fArray);
        }
        return ArrayUtils.remove(fArray, n2);
    }

    public static int[] removeElement(int[] nArray, int n2) {
        int n3 = ArrayUtils.indexOf(nArray, n2);
        if (n3 == -1) {
            return ArrayUtils.clone(nArray);
        }
        return ArrayUtils.remove(nArray, n3);
    }

    public static long[] removeElement(long[] lArray, long l2) {
        int n2 = ArrayUtils.indexOf(lArray, l2);
        if (n2 == -1) {
            return ArrayUtils.clone(lArray);
        }
        return ArrayUtils.remove(lArray, n2);
    }

    public static <T> T[] removeElement(T[] TArray, Object object) {
        int n2 = ArrayUtils.indexOf(TArray, object);
        if (n2 == -1) {
            return ArrayUtils.clone(TArray);
        }
        return ArrayUtils.remove(TArray, n2);
    }

    public static short[] removeElement(short[] sArray, short s2) {
        int n2 = ArrayUtils.indexOf(sArray, s2);
        if (n2 == -1) {
            return ArrayUtils.clone(sArray);
        }
        return ArrayUtils.remove(sArray, n2);
    }

    public static boolean[] removeElement(boolean[] blArray, boolean bl2) {
        int n2 = ArrayUtils.indexOf(blArray, bl2);
        if (n2 == -1) {
            return ArrayUtils.clone(blArray);
        }
        return ArrayUtils.remove(blArray, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] removeElements(byte[] byArray, byte ... byArray2) {
        if (ArrayUtils.isEmpty(byArray) || ArrayUtils.isEmpty(byArray2)) {
            return ArrayUtils.clone(byArray);
        }
        HashMap<Byte, MutableInt> hashMap = new HashMap<Byte, MutableInt>(byArray2.length);
        int n2 = byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Byte by2 = byArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(by2);
            if (mutableInt == null) {
                hashMap.put(by2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Byte by3 = (Byte)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(byArray, by3, n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (byte[])ArrayUtils.removeAll((Object)byArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] removeElements(char[] cArray, char ... cArray2) {
        if (ArrayUtils.isEmpty(cArray) || ArrayUtils.isEmpty(cArray2)) {
            return ArrayUtils.clone(cArray);
        }
        HashMap<Character, MutableInt> hashMap = new HashMap<Character, MutableInt>(cArray2.length);
        int n2 = cArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Character c2 = Character.valueOf(cArray2[i2]);
            MutableInt mutableInt = (MutableInt)hashMap.get(c2);
            if (mutableInt == null) {
                hashMap.put(c2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Character c3 = (Character)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(cArray, c3.charValue(), n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (char[])ArrayUtils.removeAll((Object)cArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double[] removeElements(double[] dArray, double ... dArray2) {
        if (ArrayUtils.isEmpty(dArray) || ArrayUtils.isEmpty(dArray2)) {
            return ArrayUtils.clone(dArray);
        }
        HashMap<Double, MutableInt> hashMap = new HashMap<Double, MutableInt>(dArray2.length);
        int n2 = dArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Double d2 = dArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(d2);
            if (mutableInt == null) {
                hashMap.put(d2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Double d3 = (Double)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(dArray, (double)d3, n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (double[])ArrayUtils.removeAll((Object)dArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] removeElements(float[] fArray, float ... fArray2) {
        if (ArrayUtils.isEmpty(fArray) || ArrayUtils.isEmpty(fArray2)) {
            return ArrayUtils.clone(fArray);
        }
        HashMap<Float, MutableInt> hashMap = new HashMap<Float, MutableInt>(fArray2.length);
        int n2 = fArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Float f2 = Float.valueOf(fArray2[i2]);
            MutableInt mutableInt = (MutableInt)hashMap.get(f2);
            if (mutableInt == null) {
                hashMap.put(f2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Float f3 = (Float)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(fArray, f3.floatValue(), n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (float[])ArrayUtils.removeAll((Object)fArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int[] removeElements(int[] nArray, int ... nArray2) {
        if (ArrayUtils.isEmpty(nArray) || ArrayUtils.isEmpty(nArray2)) {
            return ArrayUtils.clone(nArray);
        }
        HashMap<Integer, MutableInt> hashMap = new HashMap<Integer, MutableInt>(nArray2.length);
        int n2 = nArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Integer n3 = nArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(n3);
            if (mutableInt == null) {
                hashMap.put(n3, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n4 = (Integer)entry.getKey();
            int n5 = 0;
            int n6 = 0;
            int n7 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n8;
                if (n6 >= n7 || (n8 = ArrayUtils.indexOf(nArray, n4, n5)) < 0) continue block1;
                int n9 = n8 + 1;
                bitSet.set(n8);
                ++n6;
                n5 = n9;
            }
            break;
        }
        return (int[])ArrayUtils.removeAll((Object)nArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] removeElements(long[] lArray, long ... lArray2) {
        if (ArrayUtils.isEmpty(lArray) || ArrayUtils.isEmpty(lArray2)) {
            return ArrayUtils.clone(lArray);
        }
        HashMap<Long, MutableInt> hashMap = new HashMap<Long, MutableInt>(lArray2.length);
        int n2 = lArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = lArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(l2);
            if (mutableInt == null) {
                hashMap.put(l2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long l3 = (Long)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(lArray, l3, n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (long[])ArrayUtils.removeAll((Object)lArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T[] removeElements(T[] TArray, T ... TArray2) {
        if (ArrayUtils.isEmpty(TArray) || ArrayUtils.isEmpty(TArray2)) {
            return ArrayUtils.clone(TArray);
        }
        HashMap<T, MutableInt> hashMap = new HashMap<T, MutableInt>(TArray2.length);
        for (T t2 : TArray2) {
            MutableInt mutableInt = (MutableInt)hashMap.get(t2);
            if (mutableInt == null) {
                hashMap.put(t2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k2 = entry.getKey();
            int n2 = 0;
            int n3 = 0;
            int n4 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n5;
                if (n3 >= n4 || (n5 = ArrayUtils.indexOf(TArray, k2, n2)) < 0) continue block1;
                int n6 = n5 + 1;
                bitSet.set(n5);
                ++n3;
                n2 = n6;
            }
            break;
        }
        return (Object[])ArrayUtils.removeAll(TArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static short[] removeElements(short[] sArray, short ... sArray2) {
        if (ArrayUtils.isEmpty(sArray) || ArrayUtils.isEmpty(sArray2)) {
            return ArrayUtils.clone(sArray);
        }
        HashMap<Short, MutableInt> hashMap = new HashMap<Short, MutableInt>(sArray2.length);
        int n2 = sArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Short s2 = sArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(s2);
            if (mutableInt == null) {
                hashMap.put(s2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Short s3 = (Short)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(sArray, s3, n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (short[])ArrayUtils.removeAll((Object)sArray, bitSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] removeElements(boolean[] blArray, boolean ... blArray2) {
        if (ArrayUtils.isEmpty(blArray) || ArrayUtils.isEmpty(blArray2)) {
            return ArrayUtils.clone(blArray);
        }
        HashMap<Boolean, MutableInt> hashMap = new HashMap<Boolean, MutableInt>(2);
        int n2 = blArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Boolean bl2 = blArray2[i2];
            MutableInt mutableInt = (MutableInt)hashMap.get(bl2);
            if (mutableInt == null) {
                hashMap.put(bl2, new MutableInt(1));
                continue;
            }
            mutableInt.increment();
        }
        BitSet bitSet = new BitSet();
        Iterator iterator = hashMap.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Boolean bl3 = (Boolean)entry.getKey();
            int n3 = 0;
            int n4 = 0;
            int n5 = ((MutableInt)entry.getValue()).intValue();
            while (true) {
                int n6;
                if (n4 >= n5 || (n6 = ArrayUtils.indexOf(blArray, bl3, n3)) < 0) continue block1;
                int n7 = n6 + 1;
                bitSet.set(n6);
                ++n4;
                n3 = n7;
            }
            break;
        }
        return (boolean[])ArrayUtils.removeAll((Object)blArray, bitSet);
    }

    public static void reverse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        ArrayUtils.reverse(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(byArray.length, n3); i2 > n4; --i2, ++n4) {
                byte by2 = byArray[i2];
                byArray[i2] = byArray[n4];
                byArray[n4] = by2;
            }
        }
    }

    public static void reverse(char[] cArray) {
        if (cArray == null) {
            return;
        }
        ArrayUtils.reverse(cArray, 0, cArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(char[] cArray, int n2, int n3) {
        if (cArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(cArray.length, n3); i2 > n4; --i2, ++n4) {
                char c2 = cArray[i2];
                cArray[i2] = cArray[n4];
                cArray[n4] = c2;
            }
        }
    }

    public static void reverse(double[] dArray) {
        if (dArray == null) {
            return;
        }
        ArrayUtils.reverse(dArray, 0, dArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(double[] dArray, int n2, int n3) {
        if (dArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(dArray.length, n3); i2 > n4; --i2, ++n4) {
                double d2 = dArray[i2];
                dArray[i2] = dArray[n4];
                dArray[n4] = d2;
            }
        }
    }

    public static void reverse(float[] fArray) {
        if (fArray == null) {
            return;
        }
        ArrayUtils.reverse(fArray, 0, fArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(float[] fArray, int n2, int n3) {
        if (fArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(fArray.length, n3); i2 > n4; --i2, ++n4) {
                float f2 = fArray[i2];
                fArray[i2] = fArray[n4];
                fArray[n4] = f2;
            }
        }
    }

    public static void reverse(int[] nArray) {
        if (nArray == null) {
            return;
        }
        ArrayUtils.reverse(nArray, 0, nArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(int[] nArray, int n2, int n3) {
        if (nArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(nArray.length, n3); i2 > n4; --i2, ++n4) {
                int n5 = nArray[i2];
                nArray[i2] = nArray[n4];
                nArray[n4] = n5;
            }
        }
    }

    public static void reverse(long[] lArray) {
        if (lArray == null) {
            return;
        }
        ArrayUtils.reverse(lArray, 0, lArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(long[] lArray, int n2, int n3) {
        if (lArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(lArray.length, n3); i2 > n4; --i2, ++n4) {
                long l2 = lArray[i2];
                lArray[i2] = lArray[n4];
                lArray[n4] = l2;
            }
        }
    }

    public static void reverse(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        ArrayUtils.reverse(objectArray, 0, objectArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(Object[] objectArray, int n2, int n3) {
        if (objectArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(objectArray.length, n3); i2 > n4; --i2, ++n4) {
                Object object = objectArray[i2];
                objectArray[i2] = objectArray[n4];
                objectArray[n4] = object;
            }
        }
    }

    public static void reverse(short[] sArray) {
        if (sArray == null) {
            return;
        }
        ArrayUtils.reverse(sArray, 0, sArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(short[] sArray, int n2, int n3) {
        if (sArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(sArray.length, n3); i2 > n4; --i2, ++n4) {
                short s2 = sArray[i2];
                sArray[i2] = sArray[n4];
                sArray[n4] = s2;
            }
        }
    }

    public static void reverse(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        ArrayUtils.reverse(blArray, 0, blArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reverse(boolean[] blArray, int n2, int n3) {
        if (blArray != null) {
            int n4 = n2 < 0 ? 0 : n2;
            for (int i2 = -1 + Math.min(blArray.length, n3); i2 > n4; --i2, ++n4) {
                boolean bl2 = blArray[i2];
                blArray[i2] = blArray[n4];
                blArray[n4] = bl2;
            }
        }
    }

    public static byte[] subarray(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        return byArray2;
    }

    public static char[] subarray(char[] cArray, int n2, int n3) {
        int n4;
        if (cArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray2 = new char[n4];
        System.arraycopy(cArray, n2, cArray2, 0, n4);
        return cArray2;
    }

    public static double[] subarray(double[] dArray, int n2, int n3) {
        int n4;
        if (dArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > dArray.length) {
            n3 = dArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray2 = new double[n4];
        System.arraycopy(dArray, n2, dArray2, 0, n4);
        return dArray2;
    }

    public static float[] subarray(float[] fArray, int n2, int n3) {
        int n4;
        if (fArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > fArray.length) {
            n3 = fArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray2 = new float[n4];
        System.arraycopy(fArray, n2, fArray2, 0, n4);
        return fArray2;
    }

    public static int[] subarray(int[] nArray, int n2, int n3) {
        int n4;
        if (nArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > nArray.length) {
            n3 = nArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, n2, nArray2, 0, n4);
        return nArray2;
    }

    public static long[] subarray(long[] lArray, int n2, int n3) {
        int n4;
        if (lArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > lArray.length) {
            n3 = lArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray2 = new long[n4];
        System.arraycopy(lArray, n2, lArray2, 0, n4);
        return lArray2;
    }

    public static <T> T[] subarray(T[] TArray, int n2, int n3) {
        if (TArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > TArray.length) {
            n3 = TArray.length;
        }
        int n4 = n3 - n2;
        Class<?> clazz = TArray.getClass().getComponentType();
        if (n4 <= 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n4);
        System.arraycopy(TArray, n2, objectArray, 0, n4);
        return objectArray;
    }

    public static short[] subarray(short[] sArray, int n2, int n3) {
        int n4;
        if (sArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > sArray.length) {
            n3 = sArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray2 = new short[n4];
        System.arraycopy(sArray, n2, sArray2, 0, n4);
        return sArray2;
    }

    public static boolean[] subarray(boolean[] blArray, int n2, int n3) {
        int n4;
        if (blArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > blArray.length) {
            n3 = blArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray2 = new boolean[n4];
        System.arraycopy(blArray, n2, blArray2, 0, n4);
        return blArray2;
    }

    public static <T> T[] toArray(T ... TArray) {
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Map<Object, Object> toMap(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>((int)(1.5 * (double)objectArray.length));
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                hashMap.put(entry.getKey(), entry.getValue());
            } else {
                if (!(object instanceof Object[])) {
                    throw new IllegalArgumentException("Array element " + n2 + ", '" + object + "', is neither of type Map.Entry nor an Array");
                }
                Object[] objectArray2 = (Object[])object;
                if (objectArray2.length < 2) {
                    throw new IllegalArgumentException("Array element " + n2 + ", '" + object + "', has a length less than 2");
                }
                hashMap.put(objectArray2[0], objectArray2[1]);
            }
            ++n2;
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Boolean[] toObject(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        if (blArray.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleanArray = new Boolean[blArray.length];
        int n2 = 0;
        while (n2 < blArray.length) {
            Boolean bl2 = blArray[n2] ? Boolean.TRUE : Boolean.FALSE;
            booleanArray[n2] = bl2;
            ++n2;
        }
        return booleanArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Byte[] toObject(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] byteArray = new Byte[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            byteArray[n2] = byArray[n2];
            ++n2;
        }
        return byteArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Character[] toObject(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        if (cArray.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] characterArray = new Character[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            characterArray[n2] = Character.valueOf(cArray[n2]);
            ++n2;
        }
        return characterArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Double[] toObject(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] doubleArray = new Double[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            doubleArray[n2] = dArray[n2];
            ++n2;
        }
        return doubleArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Float[] toObject(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] floatArray = new Float[fArray.length];
        int n2 = 0;
        while (n2 < fArray.length) {
            floatArray[n2] = Float.valueOf(fArray[n2]);
            ++n2;
        }
        return floatArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Integer[] toObject(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerArray = new Integer[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            integerArray[n2] = nArray[n2];
            ++n2;
        }
        return integerArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long[] toObject(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] longArray = new Long[lArray.length];
        int n2 = 0;
        while (n2 < lArray.length) {
            longArray[n2] = lArray[n2];
            ++n2;
        }
        return longArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Short[] toObject(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        if (sArray.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] shortArray = new Short[sArray.length];
        int n2 = 0;
        while (n2 < sArray.length) {
            shortArray[n2] = sArray[n2];
            ++n2;
        }
        return shortArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toPrimitive(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        int n2 = 0;
        while (n2 < byteArray.length) {
            byArray[n2] = byteArray[n2];
            ++n2;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] toPrimitive(Byte[] byteArray, byte by2) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        int n2 = 0;
        while (n2 < byteArray.length) {
            Byte by3 = byteArray[n2];
            byte by4 = by3 == null ? by2 : by3;
            byArray[n2] = by4;
            ++n2;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static char[] toPrimitive(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        int n2 = 0;
        while (n2 < characterArray.length) {
            cArray[n2] = characterArray[n2].charValue();
            ++n2;
        }
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] toPrimitive(Character[] characterArray, char c2) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        int n2 = 0;
        while (n2 < characterArray.length) {
            Character c3 = characterArray[n2];
            char c4 = c3 == null ? c2 : c3.charValue();
            cArray[n2] = c4;
            ++n2;
        }
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] toPrimitive(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        int n2 = 0;
        while (n2 < doubleArray.length) {
            dArray[n2] = doubleArray[n2];
            ++n2;
        }
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double[] toPrimitive(Double[] doubleArray, double d2) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        int n2 = 0;
        while (n2 < doubleArray.length) {
            Double d3 = doubleArray[n2];
            double d4 = d3 == null ? d2 : d3;
            dArray[n2] = d4;
            ++n2;
        }
        return dArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float[] toPrimitive(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        int n2 = 0;
        while (n2 < floatArray.length) {
            fArray[n2] = floatArray[n2].floatValue();
            ++n2;
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] toPrimitive(Float[] floatArray, float f2) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        int n2 = 0;
        while (n2 < floatArray.length) {
            Float f3 = floatArray[n2];
            float f4 = f3 == null ? f2 : f3.floatValue();
            fArray[n2] = f4;
            ++n2;
        }
        return fArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] toPrimitive(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        int n2 = 0;
        while (n2 < integerArray.length) {
            nArray[n2] = integerArray[n2];
            ++n2;
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int[] toPrimitive(Integer[] integerArray, int n2) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        int n3 = 0;
        while (n3 < integerArray.length) {
            Integer n4 = integerArray[n3];
            int n5 = n4 == null ? n2 : n4;
            nArray[n3] = n5;
            ++n3;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] toPrimitive(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        int n2 = 0;
        while (n2 < longArray.length) {
            lArray[n2] = longArray[n2];
            ++n2;
        }
        return lArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] toPrimitive(Long[] longArray, long l2) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        int n2 = 0;
        while (n2 < longArray.length) {
            Long l3 = longArray[n2];
            long l4 = l3 == null ? l2 : l3;
            lArray[n2] = l4;
            ++n2;
        }
        return lArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static short[] toPrimitive(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        int n2 = 0;
        while (n2 < shortArray.length) {
            sArray[n2] = shortArray[n2];
            ++n2;
        }
        return sArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static short[] toPrimitive(Short[] shortArray, short s2) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        int n2 = 0;
        while (n2 < shortArray.length) {
            Short s3 = shortArray[n2];
            short s4 = s3 == null ? s2 : s3;
            sArray[n2] = s4;
            ++n2;
        }
        return sArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        int n2 = 0;
        while (n2 < booleanArray.length) {
            blArray[n2] = booleanArray[n2];
            ++n2;
        }
        return blArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean[] toPrimitive(Boolean[] booleanArray, boolean bl2) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        int n2 = 0;
        while (n2 < booleanArray.length) {
            Boolean bl3 = booleanArray[n2];
            boolean bl4 = bl3 == null ? bl2 : bl3;
            blArray[n2] = bl4;
            ++n2;
        }
        return blArray;
    }

    public static String toString(Object object) {
        return ArrayUtils.toString(object, "{}");
    }

    public static String toString(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        return new ToStringBuilder(object, ToStringStyle.SIMPLE_STYLE).append(object).toString();
    }
}

