/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AnnotationUtils {
    private static final ToStringStyle TO_STRING_STYLE = new ToStringStyle(){
        private static final long serialVersionUID = 1L;
        {
            this.setDefaultFullDetail(true);
            this.setArrayContentDetail(true);
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart("(");
            this.setContentEnd(")");
            this.setFieldSeparator(", ");
            this.setArrayStart("[");
            this.setArrayEnd("]");
        }

        @Override
        protected void appendDetail(StringBuffer stringBuffer, String string2, Object object) {
            if (object instanceof Annotation) {
                object = AnnotationUtils.toString((Annotation)object);
            }
            super.appendDetail(stringBuffer, string2, object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected String getShortClassName(Class<?> clazz) {
            String string2;
            Class<?> clazz2;
            block3: {
                Class<?> clazz3;
                Iterator<Class<?>> iterator = ClassUtils.getAllInterfaces(clazz).iterator();
                do {
                    boolean bl2 = iterator.hasNext();
                    clazz2 = null;
                    if (!bl2) break block3;
                } while (!Annotation.class.isAssignableFrom(clazz3 = iterator.next()));
                clazz2 = clazz3;
            }
            if (clazz2 == null) {
                string2 = "";
                return new StringBuilder(string2).insert(0, '@').toString();
            }
            string2 = clazz2.getName();
            return new StringBuilder(string2).insert(0, '@').toString();
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    private static boolean annotationArrayMemberEquals(Annotation[] annotationArray, Annotation[] annotationArray2) {
        if (annotationArray.length == annotationArray2.length) {
            int n2 = 0;
            while (true) {
                if (n2 >= annotationArray.length) {
                    return true;
                }
                if (!AnnotationUtils.equals(annotationArray[n2], annotationArray2[n2])) break;
                ++n2;
            }
        }
        return false;
    }

    private static boolean arrayMemberEquals(Class<?> clazz, Object object, Object object2) {
        if (clazz.isAnnotation()) {
            return AnnotationUtils.annotationArrayMemberEquals((Annotation[])object, (Annotation[])object2);
        }
        if (clazz.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz.equals(Short.TYPE)) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz.equals(Character.TYPE)) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz.equals(Long.TYPE)) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz.equals(Float.TYPE)) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz.equals(Double.TYPE)) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return Arrays.equals((Object[])object, (Object[])object2);
    }

    private static int arrayMemberHash(Class<?> clazz, Object object) {
        if (clazz.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])object);
        }
        if (clazz.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])object);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])object);
        }
        if (clazz.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])object);
        }
        if (clazz.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])object);
        }
        if (clazz.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])object);
        }
        if (clazz.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])object);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])object);
        }
        return Arrays.hashCode((Object[])object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(Annotation annotation, Annotation annotation2) {
        if (annotation == annotation2) return true;
        if (annotation == null || annotation2 == null) {
            return false;
        }
        Class<? extends Annotation> clazz = annotation.annotationType();
        Class<? extends Annotation> clazz2 = annotation2.annotationType();
        Validate.notNull(clazz, "Annotation %s with null annotationType()", annotation);
        Validate.notNull(clazz2, "Annotation %s with null annotationType()", annotation2);
        if (!clazz.equals(clazz2)) {
            return false;
        }
        try {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || !AnnotationUtils.isValidAnnotationMemberType(method.getReturnType())) continue;
                Object object = method.invoke((Object)annotation, new Object[0]);
                Object object2 = method.invoke((Object)annotation2, new Object[0]);
                boolean bl2 = AnnotationUtils.memberEquals(method.getReturnType(), object, object2);
                if (bl2) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int hashCode(Annotation annotation) {
        int n2 = 0;
        Method[] methodArray = annotation.annotationType().getDeclaredMethods();
        int n3 = methodArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Object object;
            Method method = methodArray[n4];
            try {
                object = method.invoke((Object)annotation, new Object[0]);
                if (object == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", method));
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            {
                int n5 = AnnotationUtils.hashMember(method.getName(), object);
                n2 += n5;
                ++n4;
                continue;
            }
            break;
        }
        return n2;
    }

    private static int hashMember(String string2, Object object) {
        int n2 = 127 * string2.hashCode();
        if (object.getClass().isArray()) {
            return n2 ^ AnnotationUtils.arrayMemberHash(object.getClass().getComponentType(), object);
        }
        if (object instanceof Annotation) {
            return n2 ^ AnnotationUtils.hashCode((Annotation)object);
        }
        return n2 ^ object.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isValidAnnotationMemberType(Class<?> clazz) {
        block5: {
            block4: {
                if (clazz == null) break block4;
                if (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                if (clazz.isPrimitive() || clazz.isEnum() || clazz.isAnnotation() || String.class.equals(clazz) || Class.class.equals(clazz)) break block5;
            }
            return false;
        }
        return true;
    }

    private static boolean memberEquals(Class<?> clazz, Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (clazz.isArray()) {
            return AnnotationUtils.arrayMemberEquals(clazz.getComponentType(), object, object2);
        }
        if (clazz.isAnnotation()) {
            return AnnotationUtils.equals((Annotation)object, (Annotation)object2);
        }
        return object.equals(object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(Annotation annotation) {
        ToStringBuilder toStringBuilder = new ToStringBuilder(annotation, TO_STRING_STYLE);
        Method[] methodArray = annotation.annotationType().getDeclaredMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            if (method.getParameterTypes().length <= 0) {
                try {
                    toStringBuilder.append(method.getName(), method.invoke((Object)annotation, new Object[0]));
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            ++n3;
        }
        return toStringBuilder.build();
    }
}

