/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private int threshold;
    private boolean thresholdExceeded;
    private long written;

    public ThresholdingOutputStream(int n2) {
        this.threshold = n2;
    }

    protected void checkThreshold(int n2) throws IOException {
        if (!this.thresholdExceeded && this.written + (long)n2 > (long)this.threshold) {
            this.thresholdReached();
            this.thresholdExceeded = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {}
        this.getStream().close();
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    public long getByteCount() {
        return this.written;
    }

    protected abstract OutputStream getStream() throws IOException;

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isThresholdExceeded() {
        return this.written > (long)this.threshold;
    }

    protected abstract void thresholdReached() throws IOException;

    @Override
    public void write(int n2) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(n2);
        this.written = 1L + this.written;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkThreshold(n3);
        this.getStream().write(byArray, n2, n3);
        this.written += (long)n3;
    }
}

