/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class TeeOutputStream
extends ProxyOutputStream {
    protected OutputStream branch;

    public TeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        super(outputStream);
        this.branch = outputStream2;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.branch.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.branch.flush();
    }

    @Override
    public void write(int n2) throws IOException {
        synchronized (this) {
            super.write(n2);
            this.branch.write(n2);
            return;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        synchronized (this) {
            super.write(byArray);
            this.branch.write(byArray);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            super.write(byArray, n2, n3);
            this.branch.write(byArray, n2, n3);
            return;
        }
    }
}

