/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    static Class class$org$apache$commons$io$output$LockableFileWriter;
    private final File lockFile;
    private final Writer out;

    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    public LockableFileWriter(File file, String string2) throws IOException {
        this(file, string2, false, null);
    }

    public LockableFileWriter(File file, String string2, boolean bl2, String string3) throws IOException {
        File file2 = file.getAbsoluteFile();
        if (file2.getParentFile() != null) {
            FileUtils.forceMkdir(file2.getParentFile());
        }
        if (file2.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (string3 == null) {
            string3 = System.getProperty("java.io.tmpdir");
        }
        File file3 = new File(string3);
        FileUtils.forceMkdir(file3);
        this.testLockDir(file3);
        this.lockFile = new File(file3, new StringBuffer().append(file2.getName()).append(LCK).toString());
        this.createLock();
        this.out = this.initWriter(file2, string2, bl2);
    }

    public LockableFileWriter(File file, boolean bl2) throws IOException {
        this(file, bl2, null);
    }

    public LockableFileWriter(File file, boolean bl2, String string2) throws IOException {
        this(file, null, bl2, string2);
    }

    public LockableFileWriter(String string2) throws IOException {
        this(string2, false, null);
    }

    public LockableFileWriter(String string2, boolean bl2) throws IOException {
        this(string2, bl2, null);
    }

    public LockableFileWriter(String string2, boolean bl2, String string3) throws IOException {
        this(new File(string2), bl2, string3);
    }

    static Class class$(String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createLock() throws IOException {
        Class clazz;
        if (class$org$apache$commons$io$output$LockableFileWriter == null) {
            class$org$apache$commons$io$output$LockableFileWriter = clazz = LockableFileWriter.class$("org.apache.commons.io.output.LockableFileWriter");
        } else {
            clazz = class$org$apache$commons$io$output$LockableFileWriter;
        }
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException(new StringBuffer().append("Can't write file, lock ").append(this.lockFile.getAbsolutePath()).append(" exists").toString());
            }
            this.lockFile.deleteOnExit();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Writer initWriter(File var1_1, String var2_2, boolean var3_3) throws IOException {
        var4_4 = var1_1.exists();
        var5_5 = null;
        if (var2_2 != null) ** GOTO lbl6
        return new FileWriter(var1_1.getAbsolutePath(), var3_3);
lbl6:
        // 1 sources

        var6_6 = new FileOutputStream(var1_1.getAbsolutePath(), var3_3);
        var7_7 = new OutputStreamWriter((OutputStream)var6_6, var2_2);
        return var7_7;
        catch (IOException var8_8) lbl-1000:
        // 2 sources

        {
            while (true) {
                IOUtils.closeQuietly(null);
                IOUtils.closeQuietly(var5_5);
                this.lockFile.delete();
                if (!var4_4) {
                    var1_1.delete();
                }
                throw var8_9;
            }
        }
        catch (RuntimeException var11_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                IOUtils.closeQuietly(null);
                IOUtils.closeQuietly(var5_5);
                this.lockFile.delete();
                if (!var4_4) {
                    var1_1.delete();
                }
                throw var11_12;
            }
        }
        catch (RuntimeException var11_13) {
            var5_5 = var6_6;
            ** continue;
        }
        catch (IOException var8_10) {
            var5_5 = var6_6;
            ** continue;
        }
    }

    private void testLockDir(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(new StringBuffer().append("Could not find lockDir: ").append(file.getAbsolutePath()).toString());
        }
        if (!file.canWrite()) {
            throw new IOException(new StringBuffer().append("Could not write to lockDir: ").append(file.getAbsolutePath()).toString());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
            return;
        }
        finally {
            this.lockFile.delete();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int n2) throws IOException {
        this.out.write(n2);
    }

    @Override
    public void write(String string2) throws IOException {
        this.out.write(string2);
    }

    @Override
    public void write(String string2, int n2, int n3) throws IOException {
        this.out.write(string2, n2, n3);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.out.write(cArray, n2, n3);
    }
}

