/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private long count;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public long getByteCount() {
        synchronized (this) {
            long l2 = this.count;
            return l2;
        }
    }

    public int getCount() {
        synchronized (this) {
            long l2;
            block4: {
                l2 = this.getByteCount();
                if (l2 <= Integer.MAX_VALUE) break block4;
                throw new ArithmeticException(new StringBuffer().append("The byte count ").append(l2).append(" is too large to be converted to an int").toString());
            }
            int n2 = (int)l2;
            return n2;
        }
    }

    public long resetByteCount() {
        synchronized (this) {
            long l2 = this.count;
            this.count = 0L;
            return l2;
        }
    }

    public int resetCount() {
        synchronized (this) {
            long l2;
            block4: {
                l2 = this.resetByteCount();
                if (l2 <= Integer.MAX_VALUE) break block4;
                throw new ArithmeticException(new StringBuffer().append("The byte count ").append(l2).append(" is too large to be converted to an int").toString());
            }
            int n2 = (int)l2;
            return n2;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.count = 1L + this.count;
        super.write(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.count += (long)byArray.length;
        super.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.count += (long)n3;
        super.write(byArray, n2, n3);
    }
}

