/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ByteArrayOutputStream
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private List buffers = new ArrayList();
    private int count;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int filledBufferSum;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Negative initial size: ").append(n2).toString());
        }
        this.needNewBuffer(n2);
    }

    private byte[] getBuffer(int n2) {
        return (byte[])this.buffers.get(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void needNewBuffer(int n2) {
        int n3;
        if (this.currentBufferIndex < -1 + this.buffers.size()) {
            this.filledBufferSum += this.currentBuffer.length;
            this.currentBufferIndex = 1 + this.currentBufferIndex;
            this.currentBuffer = this.getBuffer(this.currentBufferIndex);
            return;
        }
        if (this.currentBuffer == null) {
            n3 = n2;
            this.filledBufferSum = 0;
        } else {
            n3 = Math.max(this.currentBuffer.length << 1, n2 - this.filledBufferSum);
            this.filledBufferSum += this.currentBuffer.length;
        }
        this.currentBufferIndex = 1 + this.currentBufferIndex;
        this.currentBuffer = new byte[n3];
        this.buffers.add(this.currentBuffer);
    }

    @Override
    public void close() throws IOException {
    }

    public void reset() {
        synchronized (this) {
            this.count = 0;
            this.filledBufferSum = 0;
            this.currentBufferIndex = 0;
            this.currentBuffer = this.getBuffer(this.currentBufferIndex);
            return;
        }
    }

    public int size() {
        synchronized (this) {
            int n2 = this.count;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toByteArray() {
        synchronized (this) {
            int n2;
            block7: {
                n2 = this.count;
                if (n2 != 0) break block7;
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n4 >= this.buffers.size()) return byArray;
                byte[] byArray2 = this.getBuffer(n4);
                int n5 = Math.min(byArray2.length, n2);
                System.arraycopy(byArray2, 0, byArray, n3, n5);
                n3 += n5;
                if ((n2 -= n5) == 0) return byArray;
                ++n4;
                continue;
                break;
            }
        }
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string2) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string2);
    }

    @Override
    public void write(int n2) {
        synchronized (this) {
            block4: {
                int n3 = this.count - this.filledBufferSum;
                if (n3 != this.currentBuffer.length) break block4;
                this.needNewBuffer(1 + this.count);
                n3 = 0;
            }
            this.currentBuffer[n3] = (byte)n2;
            this.count = 1 + this.count;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        synchronized (this) {
            int n4 = n3 + this.count;
            int n5 = n3;
            int n6 = this.count - this.filledBufferSum;
            while (true) {
                if (n5 <= 0) {
                    this.count = n4;
                    return;
                }
                int n7 = Math.min(n5, this.currentBuffer.length - n6);
                System.arraycopy(byArray, n2 + n3 - n5, this.currentBuffer, n6, n7);
                if ((n5 -= n7) <= 0) continue;
                this.needNewBuffer(n4);
                n6 = 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        synchronized (this) {
            int n2 = this.count;
            int n3 = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n3 >= this.buffers.size()) break block5;
                        byte[] byArray = this.getBuffer(n3);
                        int n4 = Math.min(byArray.length, n2);
                        outputStream.write(byArray, 0, n4);
                        if ((n2 -= n4) != 0) break block6;
                    }
                    return;
                }
                ++n3;
            }
        }
    }
}

