/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class NullInputStream
extends InputStream {
    private boolean eof;
    private long mark = -1L;
    private boolean markSupported;
    private long position;
    private long readlimit;
    private long size;
    private boolean throwEofException;

    public NullInputStream(long l2) {
        this(l2, true, false);
    }

    public NullInputStream(long l2, boolean bl2, boolean bl3) {
        this.size = l2;
        this.markSupported = bl2;
        this.throwEofException = bl3;
    }

    private int doEndOfFile() throws EOFException {
        this.eof = true;
        if (this.throwEofException) {
            throw new EOFException();
        }
        return -1;
    }

    @Override
    public int available() {
        long l2 = this.size - this.position;
        if (l2 <= 0L) {
            return 0;
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public void close() throws IOException {
        this.eof = false;
        this.position = 0L;
        this.mark = -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mark(int n2) {
        synchronized (this) {
            if (!this.markSupported) {
                throw new UnsupportedOperationException("Mark not supported");
            }
            this.mark = this.position;
            this.readlimit = n2;
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return this.markSupported;
    }

    protected int processByte() {
        return 0;
    }

    protected void processBytes(byte[] byArray, int n2, int n3) {
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position = 1L + this.position;
        return this.processByte();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += (long)n3;
        int n4 = n3;
        if (this.position > this.size) {
            n4 = n3 - (int)(this.position - this.size);
            this.position = this.size;
        }
        this.processBytes(byArray, n2, n4);
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() throws IOException {
        synchronized (this) {
            if (!this.markSupported) {
                throw new UnsupportedOperationException("Mark not supported");
            }
            if (this.mark < 0L) {
                throw new IOException("No position has been marked");
            }
            if (this.position > this.mark + this.readlimit) {
                throw new IOException(new StringBuffer().append("Marked position [").append(this.mark).append("] is no longer valid - passed the read limit [").append(this.readlimit).append("]").toString());
            }
            this.position = this.mark;
            this.eof = false;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long skip(long l2) throws IOException {
        if (this.eof) {
            throw new IOException("Skip after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position = l2 + this.position;
        long l3 = l2;
        if (this.position <= this.size) return l3;
        long l4 = l2 - (this.position - this.size);
        this.position = this.size;
        return l4;
    }
}

