/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class CountingInputStream
extends ProxyInputStream {
    private long count;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long getByteCount() {
        synchronized (this) {
            long l2 = this.count;
            return l2;
        }
    }

    public int getCount() {
        synchronized (this) {
            long l2;
            block4: {
                l2 = this.getByteCount();
                if (l2 <= Integer.MAX_VALUE) break block4;
                throw new ArithmeticException(new StringBuffer().append("The byte count ").append(l2).append(" is too large to be converted to an int").toString());
            }
            int n2 = (int)l2;
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read() throws IOException {
        int n2 = super.read();
        long l2 = this.count;
        long l3 = n2 >= 0 ? 1L : 0L;
        this.count = l3 + l2;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = super.read(byArray);
        long l2 = this.count;
        long l3 = n2 >= 0 ? (long)n2 : 0L;
        this.count = l3 + l2;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        long l2 = this.count;
        long l3 = n4 >= 0 ? (long)n4 : 0L;
        this.count = l3 + l2;
        return n4;
    }

    public long resetByteCount() {
        synchronized (this) {
            long l2 = this.count;
            this.count = 0L;
            return l2;
        }
    }

    public int resetCount() {
        synchronized (this) {
            long l2;
            block4: {
                l2 = this.resetByteCount();
                if (l2 <= Integer.MAX_VALUE) break block4;
                throw new ArithmeticException(new StringBuffer().append("The byte count ").append(l2).append(" is too large to be converted to an int").toString());
            }
            int n2 = (int)l2;
            return n2;
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = super.skip(l2);
        this.count = l3 + this.count;
        return l3;
    }
}

