/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFilter
extends AbstractFileFilter {
    private String[] wildcards;

    public WildcardFilter(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string2};
    }

    public WildcardFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
    }

    public WildcardFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean accept(File file) {
        if (!file.isDirectory()) {
            for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
                if (!FilenameUtils.wildcardMatch(file.getName(), this.wildcards[i2])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean accept(File file, String string2) {
        if (file == null || !new File(file, string2).isDirectory()) {
            for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
                if (!FilenameUtils.wildcardMatch(string2, this.wildcards[i2])) continue;
                return true;
            }
        }
        return false;
    }
}

