/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFileFilter
extends AbstractFileFilter {
    private IOCase caseSensitivity;
    private String[] wildcards;

    public WildcardFileFilter(String string2) {
        this(string2, null);
    }

    public WildcardFileFilter(String string2, IOCase iOCase) {
        if (string2 == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string2};
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    public WildcardFileFilter(List list) {
        this(list, null);
    }

    public WildcardFileFilter(List list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    public WildcardFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = stringArray;
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string2 = file.getName();
        for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
            if (!FilenameUtils.wildcardMatch(string2, this.wildcards[i2], this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string2) {
        for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
            if (!FilenameUtils.wildcardMatch(string2, this.wildcards[i2], this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }
}

