/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter {
    private String[] suffixes;

    public SuffixFileFilter(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{string2};
    }

    public SuffixFileFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = list.toArray(new String[list.size()]);
    }

    public SuffixFileFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = stringArray;
    }

    @Override
    public boolean accept(File file) {
        String string2 = file.getName();
        for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
            if (!string2.endsWith(this.suffixes[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string2) {
        for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
            if (!string2.endsWith(this.suffixes[i2])) continue;
            return true;
        }
        return false;
    }
}

