/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter {
    private String[] prefixes;

    public PrefixFileFilter(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{string2};
    }

    public PrefixFileFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = list.toArray(new String[list.size()]);
    }

    public PrefixFileFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = stringArray;
    }

    @Override
    public boolean accept(File file) {
        String string2 = file.getName();
        for (int i2 = 0; i2 < this.prefixes.length; ++i2) {
            if (!string2.startsWith(this.prefixes[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string2) {
        for (int i2 = 0; i2 < this.prefixes.length; ++i2) {
            if (!string2.startsWith(this.prefixes[i2])) continue;
            return true;
        }
        return false;
    }
}

