/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class OrFileFilter
extends AbstractFileFilter
implements ConditionalFileFilter {
    private List fileFilters;

    public OrFileFilter() {
        this.fileFilters = new ArrayList();
    }

    public OrFileFilter(List list) {
        if (list == null) {
            this.fileFilters = new ArrayList();
            return;
        }
        this.fileFilters = new ArrayList(list);
    }

    public OrFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (iOFileFilter == null || iOFileFilter2 == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        this.fileFilters = new ArrayList();
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    @Override
    public boolean accept(File file) {
        Iterator iterator = this.fileFilters.iterator();
        while (iterator.hasNext()) {
            if (!((IOFileFilter)iterator.next()).accept(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string2) {
        Iterator iterator = this.fileFilters.iterator();
        while (iterator.hasNext()) {
            if (!((IOFileFilter)iterator.next()).accept(file, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(iOFileFilter);
    }

    @Override
    public List getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List list) {
        this.fileFilters = list;
    }
}

