/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter {
    private IOCase caseSensitivity;
    private String[] names;

    public NameFileFilter(String string2) {
        this(string2, null);
    }

    public NameFileFilter(String string2, IOCase iOCase) {
        if (string2 == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{string2};
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    public NameFileFilter(List list) {
        this(list, null);
    }

    public NameFileFilter(List list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = list.toArray(new String[list.size()]);
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    public NameFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = stringArray;
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        this.caseSensitivity = iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string2 = file.getName();
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            if (!this.caseSensitivity.checkEquals(string2, this.names[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string2) {
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            if (!this.caseSensitivity.checkEquals(string2, this.names[i2])) continue;
            return true;
        }
        return false;
    }
}

