/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final char DIR_SEPARATOR = '\u0000';
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final String LINE_SEPARATOR;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";

    static {
        DIR_SEPARATOR = File.separatorChar;
        StringWriter stringWriter = new StringWriter(4);
        new PrintWriter(stringWriter).println();
        LINE_SEPARATOR = stringWriter.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(Reader reader) {
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(Writer writer) {
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (-1 != n2) {
            if (n2 != inputStream2.read()) return false;
            n2 = inputStream.read();
        }
        if (inputStream2.read() == -1) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        if (!(reader2 instanceof BufferedReader)) {
            reader2 = new BufferedReader(reader2);
        }
        int n2 = reader.read();
        while (-1 != n2) {
            if (n2 != reader2.read()) return false;
            n2 = reader.read();
        }
        if (reader2.read() == -1) return true;
        return false;
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.copy((Reader)new InputStreamReader(inputStream), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string2) throws IOException {
        if (string2 == null) {
            IOUtils.copy(inputStream, writer);
            return;
        }
        IOUtils.copy((Reader)new InputStreamReader(inputStream, string2), writer);
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string2) throws IOException {
        if (string2 == null) {
            IOUtils.copy(reader, outputStream);
            return;
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LineIterator lineIterator(InputStream inputStream, String string2) throws IOException {
        InputStreamReader inputStreamReader;
        if (string2 == null) {
            inputStreamReader = new InputStreamReader(inputStream);
            return new LineIterator(inputStreamReader);
        }
        inputStreamReader = new InputStreamReader(inputStream, string2);
        return new LineIterator(inputStreamReader);
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static List readLines(InputStream inputStream) throws IOException {
        return IOUtils.readLines(new InputStreamReader(inputStream));
    }

    public static List readLines(InputStream inputStream, String string2) throws IOException {
        if (string2 == null) {
            return IOUtils.readLines(inputStream);
        }
        return IOUtils.readLines(new InputStreamReader(inputStream, string2));
    }

    public static List readLines(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            arrayList.add(string2);
            string2 = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, byteArrayOutputStream, string2);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(String string2) throws IOException {
        return string2.getBytes();
    }

    public static char[] toCharArray(InputStream inputStream) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string2) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, charArrayWriter, string2);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static InputStream toInputStream(String string2) {
        return new ByteArrayInputStream(string2.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream toInputStream(String string2, String string3) throws IOException {
        byte[] byArray;
        if (string3 != null) {
            byArray = string2.getBytes(string3);
            return new ByteArrayInputStream(byArray);
        }
        byArray = string2.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static String toString(InputStream inputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, stringWriter, string2);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray) throws IOException {
        return new String(byArray);
    }

    public static String toString(byte[] byArray, String string2) throws IOException {
        if (string2 == null) {
            return new String(byArray);
        }
        return new String(byArray, string2);
    }

    public static void write(String string2, OutputStream outputStream) throws IOException {
        if (string2 != null) {
            outputStream.write(string2.getBytes());
        }
    }

    public static void write(String string2, OutputStream outputStream, String string3) throws IOException {
        block3: {
            block2: {
                if (string2 == null) break block2;
                if (string3 != null) break block3;
                IOUtils.write(string2, outputStream);
            }
            return;
        }
        outputStream.write(string2.getBytes(string3));
    }

    public static void write(String string2, Writer writer) throws IOException {
        if (string2 != null) {
            writer.write(string2);
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string2) throws IOException {
        block3: {
            block2: {
                if (stringBuffer == null) break block2;
                if (string2 != null) break block3;
                IOUtils.write(stringBuffer, outputStream);
            }
            return;
        }
        outputStream.write(stringBuffer.toString().getBytes(string2));
    }

    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string2) throws IOException {
        block3: {
            block2: {
                if (byArray == null) break block2;
                if (string2 != null) break block3;
                IOUtils.write(byArray, writer);
            }
            return;
        }
        writer.write(new String(byArray, string2));
    }

    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes());
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string2) throws IOException {
        block3: {
            block2: {
                if (cArray == null) break block2;
                if (string2 != null) break block3;
                IOUtils.write(cArray, outputStream);
            }
            return;
        }
        outputStream.write(new String(cArray).getBytes(string2));
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection collection, String string2, OutputStream outputStream) throws IOException {
        if (collection != null) {
            if (string2 == null) {
                string2 = LINE_SEPARATOR;
            }
            for (Object e2 : collection) {
                if (e2 != null) {
                    outputStream.write(e2.toString().getBytes());
                }
                outputStream.write(string2.getBytes());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection collection, String string2, OutputStream outputStream, String string3) throws IOException {
        if (string3 == null) {
            IOUtils.writeLines(collection, string2, outputStream);
            return;
        } else {
            if (collection == null) return;
            if (string2 == null) {
                string2 = LINE_SEPARATOR;
            }
            for (Object e2 : collection) {
                if (e2 != null) {
                    outputStream.write(e2.toString().getBytes(string3));
                }
                outputStream.write(string2.getBytes(string3));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection collection, String string2, Writer writer) throws IOException {
        if (collection != null) {
            if (string2 == null) {
                string2 = LINE_SEPARATOR;
            }
            for (Object e2 : collection) {
                if (e2 != null) {
                    writer.write(e2.toString());
                }
                writer.write(string2);
            }
        }
    }
}

