/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;

public final class IOCase
implements Serializable {
    public static final IOCase INSENSITIVE;
    public static final IOCase SENSITIVE;
    public static final IOCase SYSTEM;
    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = true;
        SENSITIVE = new IOCase("Sensitive", bl2);
        INSENSITIVE = new IOCase("Insensitive", false);
        if (FilenameUtils.isSystemWindows()) {
            bl2 = false;
        }
        SYSTEM = new IOCase("System", bl2);
    }

    private IOCase(String string2, boolean bl2) {
        this.name = string2;
        this.sensitive = bl2;
    }

    public static IOCase forName(String string2) {
        if (IOCase.SENSITIVE.name.equals(string2)) {
            return SENSITIVE;
        }
        if (IOCase.INSENSITIVE.name.equals(string2)) {
            return INSENSITIVE;
        }
        if (IOCase.SYSTEM.name.equals(string2)) {
            return SYSTEM;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Invalid IOCase name: ").append(string2).toString());
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkEndsWith(String string2, String string3) {
        boolean bl2;
        int n2 = string3.length();
        if (!this.sensitive) {
            bl2 = true;
            return string2.regionMatches(bl2, string2.length() - n2, string3, 0, n2);
        }
        bl2 = false;
        return string2.regionMatches(bl2, string2.length() - n2, string3, 0, n2);
    }

    public boolean checkEquals(String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.sensitive) {
            return string2.equals(string3);
        }
        return string2.equalsIgnoreCase(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkRegionMatches(String string2, int n2, String string3) {
        boolean bl2;
        if (!this.sensitive) {
            bl2 = true;
            return string2.regionMatches(bl2, n2, string3, 0, string3.length());
        }
        bl2 = false;
        return string2.regionMatches(bl2, n2, string3, 0, string3.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkStartsWith(String string2, String string3) {
        boolean bl2;
        if (!this.sensitive) {
            bl2 = true;
            return string2.regionMatches(bl2, 0, string3, 0, string3.length());
        }
        bl2 = false;
        return string2.regionMatches(bl2, 0, string3, 0, string3.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String convertCase(String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.sensitive) return string2;
        return string2.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.sensitive;
    }

    public String toString() {
        return this.name;
    }
}

