/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _cbuffer;
    private static final char[] _hexcodes;
    private static final StringBuffer _lbuffer;
    private static final int[] _shifts;

    static {
        _lbuffer = new StringBuffer(8);
        _cbuffer = new StringBuffer(2);
        _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};
    }

    private static StringBuffer dump(byte by2) {
        _cbuffer.setLength(0);
        for (int i2 = 0; i2 < 2; ++i2) {
            _cbuffer.append(_hexcodes[0xF & by2 >> _shifts[i2 + 6]]);
        }
        return _cbuffer;
    }

    private static StringBuffer dump(long l2) {
        _lbuffer.setLength(0);
        for (int i2 = 0; i2 < 8; ++i2) {
            _lbuffer.append(_hexcodes[0xF & (int)(l2 >> _shifts[i2])]);
        }
        return _lbuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void dump(byte[] byArray, long l2, OutputStream outputStream, int n2) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("illegal index: ").append(n2).append(" into array of length ").append(byArray.length).toString());
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l3 = l2 + (long)n2;
        StringBuffer stringBuffer = new StringBuffer(74);
        int n3 = n2;
        while (n3 < byArray.length) {
            int n4 = byArray.length - n3;
            if (n4 > 16) {
                n4 = 16;
            }
            stringBuffer.append(HexDump.dump(l3)).append(' ');
            for (int i2 = 0; i2 < 16; ++i2) {
                if (i2 < n4) {
                    stringBuffer.append(HexDump.dump(byArray[i2 + n3]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                if (byArray[i3 + n3] >= 32 && byArray[i3 + n3] < 127) {
                    stringBuffer.append((char)byArray[i3 + n3]);
                    continue;
                }
                stringBuffer.append('.');
            }
            stringBuffer.append(EOL);
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
            stringBuffer.setLength(0);
            l3 += (long)n4;
            n3 += 16;
        }
        return;
    }
}

