/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char OTHER_SEPARATOR = '\u0000';
    private static final char SYSTEM_SEPARATOR = '\u0000';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    static {
        SYSTEM_SEPARATOR = File.separatorChar;
        OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String concat(String string2, String string3) {
        block7: {
            block6: {
                int n2 = FilenameUtils.getPrefixLength(string3);
                if (n2 < 0) break block6;
                if (n2 > 0) {
                    return FilenameUtils.normalize(string3);
                }
                if (string2 != null) break block7;
            }
            return null;
        }
        int n3 = string2.length();
        if (n3 == 0) {
            return FilenameUtils.normalize(string3);
        }
        if (FilenameUtils.isSeparator(string2.charAt(n3 - 1))) {
            return FilenameUtils.normalize(new StringBuffer().append(string2).append(string3).toString());
        }
        return FilenameUtils.normalize(new StringBuffer().append(string2).append('/').append(string3).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String doGetFullPath(String string2, boolean bl2) {
        int n2;
        if (string2 == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string2);
        if (n3 < 0) {
            return null;
        }
        if (n3 >= string2.length()) {
            if (!bl2) return string2;
            return FilenameUtils.getPrefix(string2);
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string2);
        if (n4 < 0) {
            return string2.substring(0, n3);
        }
        if (bl2) {
            n2 = 1;
            return string2.substring(0, n4 + n2);
        }
        n2 = 0;
        return string2.substring(0, n4 + n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String doGetPath(String string2, int n2) {
        int n3;
        if (string2 == null || (n3 = FilenameUtils.getPrefixLength(string2)) < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string2);
        if (n3 < string2.length() && n4 >= 0) {
            return string2.substring(n3, n4 + n2);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String doNormalize(String string2, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.length();
        if (n2 == 0) return string2;
        int n3 = FilenameUtils.getPrefixLength(string2);
        if (n3 < 0) {
            return null;
        }
        char[] cArray = new char[n2 + 2];
        string2.getChars(0, string2.length(), cArray, 0);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != OTHER_SEPARATOR) continue;
            cArray[i2] = SYSTEM_SEPARATOR;
        }
        boolean bl3 = true;
        if (cArray[n2 - 1] != SYSTEM_SEPARATOR) {
            int n4 = n2 + 1;
            cArray[n2] = SYSTEM_SEPARATOR;
            bl3 = false;
            n2 = n4;
        }
        for (int i3 = n3 + 1; i3 < n2; ++i3) {
            if (cArray[i3] != SYSTEM_SEPARATOR || cArray[i3 - 1] != SYSTEM_SEPARATOR) continue;
            System.arraycopy(cArray, i3, cArray, i3 - 1, n2 - i3);
            --n2;
            --i3;
        }
        for (int i4 = n3 + 1; i4 < n2; ++i4) {
            if (cArray[i4] != SYSTEM_SEPARATOR || cArray[i4 - 1] != '.' || i4 != n3 + 1 && cArray[i4 - 2] != SYSTEM_SEPARATOR) continue;
            if (i4 == n2 - 1) {
                bl3 = true;
            }
            System.arraycopy(cArray, i4 + 1, cArray, i4 - 1, n2 - i4);
            n2 -= 2;
            --i4;
        }
        int n5 = n3 + 2;
        while (true) {
            block13: {
                block15: {
                    block14: {
                        if (n5 >= n2) break block14;
                        if (cArray[n5] != SYSTEM_SEPARATOR || cArray[n5 - 1] != '.' || cArray[n5 - 2] != '.' || n5 != n3 + 2 && cArray[n5 - 3] != SYSTEM_SEPARATOR) break block13;
                        if (n5 == n3 + 2) {
                            return null;
                        }
                        if (n5 == n2 - 1) {
                            bl3 = true;
                        }
                        break block15;
                    }
                    if (n2 <= 0) {
                        return "";
                    }
                    if (n2 <= n3) {
                        return new String(cArray, 0, n2);
                    }
                    if (!bl3) return new String(cArray, 0, n2 - 1);
                    if (!bl2) return new String(cArray, 0, n2 - 1);
                    return new String(cArray, 0, n2);
                }
                for (int i5 = n5 - 4; i5 >= n3; --i5) {
                    if (cArray[i5] != SYSTEM_SEPARATOR) continue;
                    System.arraycopy(cArray, n5 + 1, cArray, i5 + 1, n2 - n5);
                    n2 -= n5 - i5;
                    n5 = i5 + 1;
                    break block13;
                }
                System.arraycopy(cArray, n5 + 1, cArray, n3, n2 - n5);
                n2 -= n5 + 1 - n3;
                n5 = n3 + 1;
            }
            ++n5;
        }
    }

    public static boolean equals(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, false, IOCase.SENSITIVE);
    }

    public static boolean equals(String string2, String string3, boolean bl2, IOCase iOCase) {
        if (string2 == null || string3 == null) {
            return string2 == string3;
        }
        if (bl2) {
            string2 = FilenameUtils.normalize(string2);
            string3 = FilenameUtils.normalize(string3);
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        return iOCase.checkEquals(string2, string3);
    }

    public static boolean equalsNormalized(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, true, IOCase.SYSTEM);
    }

    public static boolean equalsOnSystem(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, false, IOCase.SYSTEM);
    }

    public static String getBaseName(String string2) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string2));
    }

    public static String getExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string2);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(n2 + 1);
    }

    public static String getFullPath(String string2) {
        return FilenameUtils.doGetFullPath(string2, true);
    }

    public static String getFullPathNoEndSeparator(String string2) {
        return FilenameUtils.doGetFullPath(string2, false);
    }

    public static String getName(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.substring(1 + FilenameUtils.indexOfLastSeparator(string2));
    }

    public static String getPath(String string2) {
        return FilenameUtils.doGetPath(string2, 1);
    }

    public static String getPathNoEndSeparator(String string2) {
        return FilenameUtils.doGetPath(string2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getPrefix(String string2) {
        int n2;
        if (string2 == null || (n2 = FilenameUtils.getPrefixLength(string2)) < 0) {
            return null;
        }
        if (n2 > string2.length()) {
            return new StringBuffer().append(string2).append('/').toString();
        }
        return string2.substring(0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPrefixLength(String string2) {
        int n2 = 1;
        if (string2 == null) {
            return -1;
        }
        int n3 = string2.length();
        if (n3 == 0) {
            return 0;
        }
        char c2 = string2.charAt(0);
        if (c2 == ':') {
            return -1;
        }
        if (n3 == n2) {
            if (c2 == '~') {
                return 2;
            }
            if (FilenameUtils.isSeparator(c2)) return n2;
            return 0;
        }
        if (c2 == '~') {
            int n4 = string2.indexOf(47, n2);
            int n5 = string2.indexOf(92, n2);
            if (n4 == -1 && n5 == -1) {
                return n3 + 1;
            }
            if (n4 == -1) {
                n4 = n5;
            }
            if (n5 != -1) return 1 + Math.min(n4, n5);
            n5 = n4;
            return 1 + Math.min(n4, n5);
        }
        char c3 = string2.charAt(n2);
        if (c3 == ':') {
            char c4 = Character.toUpperCase(c2);
            if (c4 < 'A') return -1;
            if (c4 > 'Z') return -1;
            if (n3 == 2) return 2;
            if (FilenameUtils.isSeparator(string2.charAt(2))) return 3;
            return 2;
        }
        if (FilenameUtils.isSeparator(c2) && FilenameUtils.isSeparator(c3)) {
            int n6 = string2.indexOf(47, 2);
            int n7 = string2.indexOf(92, 2);
            if (n6 == -1) {
                if (n7 == -1) return -1;
            }
            if (n6 == 2) return -1;
            if (n7 == 2) {
                return -1;
            }
            if (n6 == -1) {
                n6 = n7;
            }
            if (n7 != -1) return 1 + Math.min(n6, n7);
            n7 = n6;
            return 1 + Math.min(n6, n7);
        }
        if (FilenameUtils.isSeparator(c2)) return n2;
        return 0;
    }

    public static int indexOfExtension(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.lastIndexOf(46);
        if (FilenameUtils.indexOfLastSeparator(string2) > n2) {
            n2 = -1;
        }
        return n2;
    }

    public static int indexOfLastSeparator(String string2) {
        if (string2 == null) {
            return -1;
        }
        return Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isExtension(String string2, String string3) {
        block5: {
            block4: {
                if (string2 == null) break block4;
                if (string3 != null && string3.length() != 0) {
                    return FilenameUtils.getExtension(string2).equals(string3);
                }
                if (FilenameUtils.indexOfExtension(string2) == -1) break block5;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isExtension(String string2, Collection collection) {
        boolean bl2 = true;
        if (string2 == null) {
            return false;
        }
        if (collection == null || collection.isEmpty()) {
            if (FilenameUtils.indexOfExtension(string2) != -1) return false;
            return bl2;
        }
        String string3 = FilenameUtils.getExtension(string2);
        Iterator iterator = collection.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!string3.equals(iterator.next()));
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isExtension(String string2, String[] stringArray) {
        boolean bl2 = true;
        if (string2 == null) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            if (FilenameUtils.indexOfExtension(string2) != -1) return false;
            return bl2;
        }
        String string3 = FilenameUtils.getExtension(string2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string3.equals(stringArray[n2])) {
                return bl2;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    public static String normalize(String string2) {
        return FilenameUtils.doNormalize(string2, true);
    }

    public static String normalizeNoEndSeparator(String string2) {
        return FilenameUtils.doNormalize(string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String removeExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string2);
        if (n2 == -1) return string2;
        return string2.substring(0, n2);
    }

    public static String separatorsToSystem(String string2) {
        if (string2 == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(string2);
        }
        return FilenameUtils.separatorsToUnix(string2);
    }

    public static String separatorsToUnix(String string2) {
        if (string2 == null || string2.indexOf(92) == -1) {
            return string2;
        }
        return string2.replace('\\', '/');
    }

    public static String separatorsToWindows(String string2) {
        if (string2 == null || string2.indexOf(47) == -1) {
            return string2;
        }
        return string2.replace('/', '\\');
    }

    /*
     * Enabled aggressive block sorting
     */
    static String[] splitOnTokens(String string2) {
        if (string2.indexOf("?") == -1 && string2.indexOf("*") == -1) {
            return new String[]{string2};
        }
        char[] cArray = string2.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '?' || cArray[i2] == '*') {
                if (stringBuffer.length() != 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                if (cArray[i2] == '?') {
                    arrayList.add("?");
                    continue;
                }
                if (arrayList.size() != 0 && (i2 <= 0 || arrayList.get(-1 + arrayList.size()).equals("*"))) continue;
                arrayList.add("*");
                continue;
            }
            stringBuffer.append(cArray[i2]);
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean wildcardMatch(String string2, String string3) {
        return FilenameUtils.wildcardMatch(string2, string3, IOCase.SENSITIVE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean wildcardMatch(String string2, String string3, IOCase iOCase) {
        if (string2 == null && string3 == null) {
            return true;
        }
        if (string2 == null || string3 == null) {
            return false;
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        String string4 = iOCase.convertCase(string2);
        String[] stringArray = FilenameUtils.splitOnTokens(iOCase.convertCase(string3));
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            if (stack.size() > 0) {
                int[] nArray = (int[])stack.pop();
                n3 = nArray[0];
                n2 = nArray[1];
                bl2 = true;
            }
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals("?")) {
                    ++n2;
                    bl2 = false;
                } else if (stringArray[n3].equals("*")) {
                    bl2 = true;
                    if (n3 == -1 + stringArray.length) {
                        n2 = string4.length();
                    }
                } else {
                    if (bl2) {
                        if ((n2 = string4.indexOf(stringArray[n3], n2)) == -1) break;
                        int n4 = string4.indexOf(stringArray[n3], n2 + 1);
                        if (n4 >= 0) {
                            stack.push(new int[]{n3, n4});
                        }
                    } else if (!string4.startsWith(stringArray[n3], n2)) break;
                    n2 += stringArray[n3].length();
                    bl2 = false;
                }
                ++n3;
            }
            if (n3 != stringArray.length || n2 != string4.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    public static boolean wildcardMatchOnSystem(String string2, String string3) {
        return FilenameUtils.wildcardMatch(string2, string3, IOCase.SYSTEM);
    }
}

