/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;

public class FileUtils {
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;

    public static String byteCountToDisplaySize(long l2) {
        if (l2 / 0x40000000L > 0L) {
            return new StringBuffer().append(String.valueOf(l2 / 0x40000000L)).append(" GB").toString();
        }
        if (l2 / 0x100000L > 0L) {
            return new StringBuffer().append(String.valueOf(l2 / 0x100000L)).append(" MB").toString();
        }
        if (l2 / 1024L > 0L) {
            return new StringBuffer().append(String.valueOf(l2 / 1024L)).append(" KB").toString();
        }
        return new StringBuffer().append(String.valueOf(l2)).append(" bytes").toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Checksum checksum(File file, Checksum checksum) throws IOException {
        CheckedInputStream checkedInputStream;
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        CheckedInputStream checkedInputStream2 = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(file), checksum);
        }
        catch (Throwable throwable) {}
        try {
            IOUtils.copy((InputStream)checkedInputStream, (OutputStream)new NullOutputStream());
        }
        catch (Throwable throwable) {
            checkedInputStream2 = checkedInputStream;
        }
        IOUtils.closeQuietly(checkedInputStream);
        return checksum;
        {
            void var4_5;
            IOUtils.closeQuietly(checkedInputStream2);
            throw var4_5;
        }
    }

    public static long checksumCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        FileUtils.checksum(file, cRC32);
        return cRC32.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" does not exist").toString());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" is not a directory").toString());
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().append("Failed to list contents of ").append(file).toString());
        }
        IOException iOException = null;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            try {
                FileUtils.forceDelete(file2);
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cleanDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" does not exist").toString());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" is not a directory").toString());
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().append("Failed to list contents of ").append(file).toString());
        }
        IOException iOException = null;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            try {
                FileUtils.forceDeleteOnExit(file2);
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contentEquals(File var0, File var1_1) throws IOException {
        var2_2 = var0.exists();
        if (var2_2 != var1_1.exists()) lbl-1000:
        // 2 sources

        {
            return false;
        }
        if (!var2_2) {
            return true;
        }
        if (var0.isDirectory() || var1_1.isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        ** while (var0.length() != var1_1.length())
lbl10:
        // 1 sources

        if (var0.getCanonicalFile().equals(var1_1.getCanonicalFile())) {
            return true;
        }
        var3_3 = null;
        var4_4 = null;
        try {
            var5_5 = new FileInputStream(var0);
        }
        catch (Throwable var7_8) lbl-1000:
        // 3 sources

        {
            while (true) {
                IOUtils.closeQuietly(var3_3);
                IOUtils.closeQuietly(var4_4);
                throw var7_9;
            }
        }
        var6_6 = new FileInputStream(var1_1);
        try {
            var8_7 = IOUtils.contentEquals(var5_5, var6_6);
        }
        catch (Throwable var7_11) {
            var4_4 = var6_6;
            var3_3 = var5_5;
            ** continue;
        }
        IOUtils.closeQuietly(var5_5);
        IOUtils.closeQuietly(var6_6);
        return var8_7;
        catch (Throwable var7_10) {
            var3_3 = var5_5;
            var4_4 = null;
            ** GOTO lbl-1000
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection collection) {
        return collection.toArray(new File[collection.size()]);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(new StringBuffer().append("Source '").append(file).append("' does not exist").toString());
        }
        if (!file.isDirectory()) {
            throw new IOException(new StringBuffer().append("Source '").append(file).append("' exists but is not a directory").toString());
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException(new StringBuffer().append("Source '").append(file).append("' and destination '").append(file2).append("' are the same").toString());
        }
        FileUtils.doCopyDirectory(file, file2, bl2);
    }

    public static void copyDirectoryToDirectory(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Source '").append(file2).append("' is not a directory").toString());
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Destination '").append(file2).append("' is not a directory").toString());
        }
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(new StringBuffer().append("Source '").append(file).append("' does not exist").toString());
        }
        if (file.isDirectory()) {
            throw new IOException(new StringBuffer().append("Source '").append(file).append("' exists but is a directory").toString());
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException(new StringBuffer().append("Source '").append(file).append("' and destination '").append(file2).append("' are the same").toString());
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' directory cannot be created").toString());
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' exists but is read-only").toString());
        }
        FileUtils.doCopyFile(file, file2, bl2);
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Destination '").append(file2).append("' is not a directory").toString());
        }
        FileUtils.copyFile(file, new File(file2, file.getName()), bl2);
    }

    /*
     * Loose catch block
     */
    public static void copyURLToFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        try {
            IOUtils.closeQuietly(fileOutputStream);
            return;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteDirectory(File file) throws IOException {
        block3: {
            block2: {
                if (!file.exists()) break block2;
                FileUtils.cleanDirectory(file);
                if (!file.delete()) break block3;
            }
            return;
        }
        throw new IOException(new StringBuffer().append("Unable to delete directory ").append(file).append(".").toString());
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(file);
        file.deleteOnExit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void doCopyDirectory(File file, File file2, boolean bl2) throws IOException {
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' exists but is not a directory").toString());
            }
        } else {
            if (!file2.mkdirs()) {
                throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' directory cannot be created").toString());
            }
            if (bl2) {
                file2.setLastModified(file.lastModified());
            }
        }
        if (!file2.canWrite()) {
            throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' cannot be written to").toString());
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().append("Failed to list contents of ").append(file).toString());
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file3 = new File(file2, fileArray[n2].getName());
            if (fileArray[n2].isDirectory()) {
                FileUtils.doCopyDirectory(fileArray[n2], file3, bl2);
            } else {
                FileUtils.doCopyFile(fileArray[n2], file3, bl2);
            }
            ++n2;
        }
        return;
    }

    /*
     * Loose catch block
     */
    private static void doCopyFile(File file, File file2, boolean bl2) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException(new StringBuffer().append("Destination '").append(file2).append("' exists but is a directory").toString());
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        try {
            IOUtils.closeQuietly(fileOutputStream);
            if (file.length() != file2.length()) {
                throw new IOException(new StringBuffer().append("Failed to copy full contents from '").append(file).append("' to '").append(file2).append("'").toString());
            }
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
        if (bl2) {
            file2.setLastModified(file.lastModified());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
            return;
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException(new StringBuffer().append("File does not exist: ").append(file).toString());
            }
            if (file.delete()) return;
            throw new IOException(new StringBuffer().append("Unable to delete file: ").append(file).toString());
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
            return;
        }
        file.deleteOnExit();
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                throw new IOException(new StringBuffer().append("File ").append(file).append(" exists and is ").append("not a directory. Unable to create directory.").toString());
            }
        } else if (!file.mkdirs()) {
            throw new IOException(new StringBuffer().append("Unable to create directory ").append(file).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void innerListFiles(Collection collection, File file, IOFileFilter iOFileFilter) {
        File[] fileArray = file.listFiles(iOFileFilter);
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    FileUtils.innerListFiles(collection, fileArray[i2], iOFileFilter);
                    continue;
                }
                collection.add(fileArray[i2]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isFileNewer(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        return file.exists() && file.lastModified() > l2;
    }

    public static boolean isFileNewer(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append("The reference file '").append(file).append("' doesn't exist").toString());
        }
        return FileUtils.isFileNewer(file, file2.lastModified());
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileNewer(file, date.getTime());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isFileOlder(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        return file.exists() && file.lastModified() < l2;
    }

    public static boolean isFileOlder(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append("The reference file '").append(file).append("' doesn't exist").toString());
        }
        return FileUtils.isFileOlder(file, file2.lastModified());
    }

    public static boolean isFileOlder(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static Iterator iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator iterateFiles(File file, String[] stringArray, boolean bl2) {
        return FileUtils.listFiles(file, stringArray, bl2).iterator();
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    public static LineIterator lineIterator(File file, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            LineIterator lineIterator = IOUtils.lineIterator(fileInputStream, string2);
            return lineIterator;
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fileInputStream);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(fileInputStream);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Collection listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'directory' is not a directory");
        }
        if (iOFileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
        IOFileFilter iOFileFilter3 = FileFilterUtils.andFileFilter(iOFileFilter, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
        IOFileFilter iOFileFilter4 = iOFileFilter2 == null ? FalseFileFilter.INSTANCE : FileFilterUtils.andFileFilter(iOFileFilter2, DirectoryFileFilter.INSTANCE);
        LinkedList linkedList = new LinkedList();
        FileUtils.innerListFiles(linkedList, file, FileFilterUtils.orFileFilter(iOFileFilter3, iOFileFilter4));
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Collection listFiles(File file, String[] stringArray, boolean bl2) {
        IOFileFilter iOFileFilter;
        IOFileFilter iOFileFilter2 = stringArray == null ? TrueFileFilter.INSTANCE : new SuffixFileFilter(FileUtils.toSuffixes(stringArray));
        if (bl2) {
            iOFileFilter = TrueFileFilter.INSTANCE;
            return FileUtils.listFiles(file, iOFileFilter2, iOFileFilter);
        }
        iOFileFilter = FalseFileFilter.INSTANCE;
        return FileUtils.listFiles(file, iOFileFilter2, iOFileFilter);
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(new StringBuffer().append("File '").append(file).append("' exists but is a directory").toString());
            }
            if (!file.canRead()) {
                throw new IOException(new StringBuffer().append("File '").append(file).append("' cannot be read").toString());
            }
        } else {
            throw new FileNotFoundException(new StringBuffer().append("File '").append(file).append("' does not exist").toString());
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(new StringBuffer().append("File '").append(file).append("' exists but is a directory").toString());
            }
            if (!file.canWrite()) {
                throw new IOException(new StringBuffer().append("File '").append(file).append("' cannot be written to").toString());
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                throw new IOException(new StringBuffer().append("File '").append(file).append("' could not be created").toString());
            }
        }
        return new FileOutputStream(file);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray(fileInputStream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, null);
    }

    public static String readFileToString(File file, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            String string3 = IOUtils.toString(fileInputStream, string2);
            return string3;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    public static List readLines(File file) throws IOException {
        return FileUtils.readLines(file, null);
    }

    public static List readLines(File file, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            List list = IOUtils.readLines(fileInputStream, string2);
            return list;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long sizeOfDirectory(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" does not exist").toString());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append(file).append(" is not a directory").toString());
        }
        long l2 = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            l2 = file2.isDirectory() ? (l2 += FileUtils.sizeOfDirectory(file2)) : (l2 += file2.length());
            ++n2;
        }
        return l2;
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("file")) {
            return null;
        }
        String string2 = uRL.getFile().replace('/', File.separatorChar);
        int n2 = 0;
        while ((n2 = string2.indexOf(37, n2)) >= 0) {
            if (n2 + 2 >= string2.length()) continue;
            char c2 = (char)Integer.parseInt(string2.substring(n2 + 1, n2 + 3), 16);
            string2 = new StringBuffer().append(string2.substring(0, n2)).append(c2).append(string2.substring(n2 + 3)).toString();
        }
        return new File(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] toFiles(URL[] uRLArray) {
        if (uRLArray == null) return EMPTY_FILE_ARRAY;
        if (uRLArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        int n2 = 0;
        while (n2 < uRLArray.length) {
            URL uRL = uRLArray[n2];
            if (uRL != null) {
                if (!uRL.getProtocol().equals("file")) {
                    throw new IllegalArgumentException(new StringBuffer().append("URL could not be converted to a File: ").append(uRL).toString());
                }
                fileArray[n2] = FileUtils.toFile(uRL);
            }
            ++n2;
        }
        return fileArray;
    }

    private static String[] toSuffixes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = new StringBuffer().append(".").append(stringArray[i2]).toString();
        }
        return stringArray2;
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURL();
        }
        return uRLArray;
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            IOUtils.closeQuietly(FileUtils.openOutputStream(file));
        }
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new IOException(new StringBuffer().append("Unable to set the last modification time for ").append(file).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitFor(File file, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (!file.exists()) {
            int n5 = n4 + 1;
            if (n4 >= 10) {
                n4 = 0;
                int n6 = n3 + 1;
                if (n3 > n2) {
                    return false;
                }
                n3 = n6;
            } else {
                n4 = n5;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
                return true;
            }
        }
        return true;
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            return;
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    public static void writeLines(File file, String string2, Collection collection) throws IOException {
        FileUtils.writeLines(file, string2, collection, null);
    }

    public static void writeLines(File file, String string2, Collection collection, String string3) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.writeLines(collection, string3, fileOutputStream, string2);
            return;
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    public static void writeLines(File file, Collection collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null);
    }

    public static void writeLines(File file, Collection collection, String string2) throws IOException {
        FileUtils.writeLines(file, null, collection, string2);
    }

    public static void writeStringToFile(File file, String string2) throws IOException {
        FileUtils.writeStringToFile(file, string2, null);
    }

    public static void writeStringToFile(File file, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.write(string2, (OutputStream)fileOutputStream, string3);
            return;
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }
}

