/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemUtils {
    private static final int INIT_PROBLEM = -1;
    private static final FileSystemUtils INSTANCE;
    private static final int OS = 0;
    private static final int OTHER = 0;
    private static final int POSIX_UNIX = 3;
    private static final int UNIX = 2;
    private static final int WINDOWS = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        int n2;
        INSTANCE = new FileSystemUtils();
        try {
            int n3;
            String string2 = System.getProperty("os.name");
            if (string2 == null) {
                throw new IOException("os.name not found");
            }
            String string3 = string2.toLowerCase();
            n2 = string3.indexOf("windows") != -1 ? 1 : (string3.indexOf("linux") == -1 && string3.indexOf("sun os") == -1 && string3.indexOf("sunos") == -1 && string3.indexOf("solaris") == -1 && string3.indexOf("mpe/ix") == -1 && string3.indexOf("freebsd") == -1 && string3.indexOf("irix") == -1 && string3.indexOf("digital unix") == -1 && string3.indexOf("unix") == -1 && string3.indexOf("mac os x") == -1 ? (string3.indexOf("hp-ux") != -1 || (n3 = string3.indexOf("aix")) != -1 ? 3 : 0) : 2);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        OS = n2;
    }

    public static long freeSpace(String string2) throws IOException {
        return INSTANCE.freeSpaceOS(string2, OS, false);
    }

    public static long freeSpaceKb(String string2) throws IOException {
        return INSTANCE.freeSpaceOS(string2, OS, true);
    }

    long freeSpaceOS(String string2, int n2, boolean bl2) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (n2) {
            default: {
                throw new IllegalStateException("Exception caught when determining operating system");
            }
            case 1: {
                if (bl2) {
                    return this.freeSpaceWindows(string2) / 1024L;
                }
                return this.freeSpaceWindows(string2);
            }
            case 2: {
                return this.freeSpaceUnix(string2, bl2, false);
            }
            case 3: {
                return this.freeSpaceUnix(string2, bl2, true);
            }
            case 0: 
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    /*
     * Enabled aggressive block sorting
     */
    long freeSpaceUnix(String string2, boolean bl2, boolean bl3) throws IOException {
        StringTokenizer stringTokenizer;
        String string3;
        block7: {
            String[] stringArray;
            List list;
            if (string2.length() == 0) {
                throw new IllegalArgumentException("Path must not be empty");
            }
            string3 = FilenameUtils.normalize(string2);
            String string4 = "-";
            if (bl2) {
                string4 = new StringBuffer().append(string4).append("k").toString();
            }
            if (bl3) {
                string4 = new StringBuffer().append(string4).append("P").toString();
            }
            if ((list = this.performCommand(stringArray = string4.length() > 1 ? new String[]{"df", string4, string3} : new String[]{"df", string3}, 3)).size() < 2) {
                throw new IOException(new StringBuffer().append("Command line 'df' did not return info as expected for path '").append(string3).append("'- response was ").append(list).toString());
            }
            stringTokenizer = new StringTokenizer((String)list.get(1), " ");
            if (stringTokenizer.countTokens() < 4) {
                if (stringTokenizer.countTokens() == 1 && list.size() >= 3) {
                    stringTokenizer = new StringTokenizer((String)list.get(2), " ");
                    break block7;
                } else {
                    throw new IOException(new StringBuffer().append("Command line 'df' did not return data as expected for path '").append(string3).append("'- check path is valid").toString());
                }
            }
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        return this.parseBytes(stringTokenizer.nextToken(), string3);
    }

    long freeSpaceWindows(String string2) throws IOException {
        String string3 = FilenameUtils.normalize(string2);
        if (string3.length() > 2 && string3.charAt(1) == ':') {
            string3 = string3.substring(0, 2);
        }
        String[] stringArray = new String[]{"cmd.exe", "/C", new StringBuffer().append("dir /-c ").append(string3).toString()};
        List list = this.performCommand(stringArray, Integer.MAX_VALUE);
        for (int i2 = -1 + list.size(); i2 >= 0; --i2) {
            String string4 = (String)list.get(i2);
            if (string4.length() <= 0) continue;
            return this.parseDir(string4, string3);
        }
        throw new IOException(new StringBuffer().append("Command line 'dir /-c' did not return any info for path '").append(string3).append("'").toString());
    }

    Process openProcess(String[] stringArray) throws IOException {
        return Runtime.getRuntime().exec(stringArray);
    }

    long parseBytes(String string2, String string3) throws IOException {
        long l2;
        block3: {
            try {
                l2 = Long.parseLong(string2);
                if (l2 >= 0L) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(new StringBuffer().append("Command line 'df' did not return numeric data as expected for path '").append(string3).append("'- check path is valid").toString());
            }
            throw new IOException(new StringBuffer().append("Command line 'df' did not find free space in response for path '").append(string3).append("'- check path is valid").toString());
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    long parseDir(String string2, String string3) throws IOException {
        int n2;
        int n3;
        int n4 = -1 + string2.length();
        while (true) {
            n3 = 0;
            if (n4 < 0) break;
            if (Character.isDigit(string2.charAt(n4))) {
                n3 = n4 + 1;
                break;
            }
            --n4;
        }
        while (true) {
            block10: {
                block9: {
                    n2 = 0;
                    if (n4 < 0) break block9;
                    char c2 = string2.charAt(n4);
                    if (Character.isDigit(c2) || c2 == ',' || c2 == '.') break block10;
                    n2 = n4 + 1;
                }
                if (n4 >= 0) break;
                throw new IOException(new StringBuffer().append("Command line 'dir /-c' did not return valid info for path '").append(string3).append("'").toString());
            }
            --n4;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.substring(n2, n3));
        int n5 = 0;
        while (n5 < stringBuffer.length()) {
            if (stringBuffer.charAt(n5) == ',' || stringBuffer.charAt(n5) == '.') {
                int n6 = n5 - 1;
                stringBuffer.deleteCharAt(n5);
                n5 = n6;
            }
            ++n5;
        }
        return this.parseBytes(stringBuffer.toString(), string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List performCommand(String[] var1_1, int var2_2) throws IOException {
        var3_3 = new ArrayList<String>(20);
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var4_4 = this.openProcess(var1_1);
        var5_5 = var4_4.getInputStream();
        var6_6 = var4_4.getOutputStream();
        var7_7 = var4_4.getErrorStream();
        var11_9 = new BufferedReader(new InputStreamReader(var5_5));
        {
            catch (Throwable var10_14) lbl-1000:
            // 2 sources

            {
                while (true) {
                    IOUtils.closeQuietly(var5_5);
                    IOUtils.closeQuietly(var6_6);
                    IOUtils.closeQuietly(var7_7);
                    IOUtils.closeQuietly(var8_8);
                    if (var4_4 == null) throw var10_15;
                    var4_4.destroy();
                    throw var10_15;
                }
            }
            catch (InterruptedException var9_13) {
                var8_8 = null;
                throw new IOException(new StringBuffer().append("Command line threw an InterruptedException '").append(var9_12.getMessage()).append("' for command ").append(Arrays.asList(var1_1)).toString());
            }
            try {
                var12_10 = var11_9.readLine();
                while (var12_10 != null && var3_3.size() < var2_2) {
                    var3_3.add(var12_10.toLowerCase().trim());
                    var12_10 = var11_9.readLine();
                }
                var4_4.waitFor();
                if (var4_4.exitValue() != 0) {
                    throw new IOException(new StringBuffer().append("Command line returned OS error code '").append(var4_4.exitValue()).append("' for command ").append(Arrays.asList(var1_1)).toString());
                }
            }
            catch (InterruptedException var9_11) {}
            var8_8 = var11_9;
            {
                throw new IOException(new StringBuffer().append("Command line threw an InterruptedException '").append(var9_12.getMessage()).append("' for command ").append(Arrays.asList(var1_1)).toString());
            }
        }
        try {
            if (var3_3.size() == 0) {
                throw new IOException(new StringBuffer().append("Command line did not return any info for command ").append(Arrays.asList(var1_1)).toString());
            }
        }
        catch (Throwable var10_16) {
            var8_8 = var11_9;
            ** continue;
        }
        IOUtils.closeQuietly(var5_5);
        IOUtils.closeQuietly(var6_6);
        IOUtils.closeQuietly(var7_7);
        IOUtils.closeQuietly(var11_9);
        if (var4_4 == null) return var3_3;
        var4_4.destroy();
        return var3_3;
    }
}

