/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileDeleteStrategy {
    public static final FileDeleteStrategy FORCE;
    public static final FileDeleteStrategy NORMAL;
    private final String name;

    static {
        NORMAL = new FileDeleteStrategy("Normal");
        FORCE = new ForceFileDeleteStrategy();
    }

    protected FileDeleteStrategy(String string2) {
        this.name = string2;
    }

    public void delete(File file) throws IOException {
        if (file.exists() && !this.doDelete(file)) {
            throw new IOException(new StringBuffer().append("Deletion failed: ").append(file).toString());
        }
    }

    public boolean deleteQuietly(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        try {
            boolean bl2 = this.doDelete(file);
            return bl2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean doDelete(File file) throws IOException {
        return file.delete();
    }

    public String toString() {
        return new StringBuffer().append("FileDeleteStrategy[").append(this.name).append("]").toString();
    }

    static class ForceFileDeleteStrategy
    extends FileDeleteStrategy {
        ForceFileDeleteStrategy() {
            super("Force");
        }

        @Override
        protected boolean doDelete(File file) throws IOException {
            FileUtils.forceDelete(file);
            return true;
        }
    }
}

