/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.io.FileDeleteStrategy;

public class FileCleaningTracker {
    volatile boolean exitWhenFinished = false;
    ReferenceQueue q = new ReferenceQueue();
    Thread reaper;
    final Collection trackers = new Vector();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTracker(String string2, Object object, FileDeleteStrategy fileDeleteStrategy) {
        synchronized (this) {
            if (this.exitWhenFinished) {
                throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
            }
            if (this.reaper == null) {
                this.reaper = new Reaper(this);
                this.reaper.start();
            }
            this.trackers.add(new Tracker(string2, fileDeleteStrategy, object, this.q));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exitWhenFinished() {
        synchronized (this) {
            this.exitWhenFinished = true;
            if (this.reaper != null) {
                Thread thread = this.reaper;
                synchronized (thread) {
                    this.reaper.interrupt();
                }
            }
            return;
        }
    }

    public int getTrackCount() {
        return this.trackers.size();
    }

    public void track(File file, Object object) {
        this.track(file, object, (FileDeleteStrategy)null);
    }

    public void track(File file, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (file == null) {
            throw new NullPointerException("The file must not be null");
        }
        this.addTracker(file.getPath(), object, fileDeleteStrategy);
    }

    public void track(String string2, Object object) {
        this.track(string2, object, (FileDeleteStrategy)null);
    }

    public void track(String string2, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (string2 == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.addTracker(string2, object, fileDeleteStrategy);
    }

    private final class Reaper
    extends Thread {
        private final FileCleaningTracker this$0;

        Reaper(FileCleaningTracker fileCleaningTracker) {
            super("File Reaper");
            this.this$0 = fileCleaningTracker;
            this.setPriority(10);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.this$0.exitWhenFinished || this.this$0.trackers.size() > 0) {
                Tracker tracker;
                try {
                    tracker = (Tracker)this.this$0.q.remove();
                    if (tracker == null) continue;
                    tracker.delete();
                }
                catch (Exception exception) {
                    continue;
                }
                tracker.clear();
                this.this$0.trackers.remove(tracker);
            }
        }
    }

    private static final class Tracker
    extends PhantomReference {
        private final FileDeleteStrategy deleteStrategy;
        private final String path;

        Tracker(String string2, FileDeleteStrategy fileDeleteStrategy, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.path = string2;
            if (fileDeleteStrategy == null) {
                fileDeleteStrategy = FileDeleteStrategy.NORMAL;
            }
            this.deleteStrategy = fileDeleteStrategy;
        }

        public boolean delete() {
            return this.deleteStrategy.deleteQuietly(new File(this.path));
        }
    }
}

