/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    private static int read(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (-1 == n2) {
            throw new EOFException("Unexpected EOF reached");
        }
        return n2;
    }

    public static double readSwappedDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(inputStream));
    }

    public static double readSwappedDouble(byte[] byArray, int n2) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(byArray, n2));
    }

    public static float readSwappedFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(inputStream));
    }

    public static float readSwappedFloat(byte[] byArray, int n2) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(byArray, n2));
    }

    public static int readSwappedInteger(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16) + ((n5 & 0xFF) << 24);
    }

    public static int readSwappedInteger(byte[] byArray, int n2) {
        return ((0xFF & byArray[n2 + 0]) << 0) + ((0xFF & byArray[n2 + 1]) << 8) + ((0xFF & byArray[n2 + 2]) << 16) + ((0xFF & byArray[n2 + 3]) << 24);
    }

    public static long readSwappedLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)EndianUtils.read(inputStream);
        }
        return EndianUtils.readSwappedLong(byArray, 0);
    }

    public static long readSwappedLong(byte[] byArray, int n2) {
        long l2 = ((0xFF & byArray[n2 + 0]) << 0) + ((0xFF & byArray[n2 + 1]) << 8) + ((0xFF & byArray[n2 + 2]) << 16) + ((0xFF & byArray[n2 + 3]) << 24);
        return ((long)(((0xFF & byArray[n2 + 4]) << 0) + ((0xFF & byArray[n2 + 5]) << 8) + ((0xFF & byArray[n2 + 6]) << 16) + ((0xFF & byArray[n2 + 7]) << 24)) << 32) + (0xFFFFFFFFL & l2);
    }

    public static short readSwappedShort(InputStream inputStream) throws IOException {
        return (short)(((0xFF & EndianUtils.read(inputStream)) << 0) + ((0xFF & EndianUtils.read(inputStream)) << 8));
    }

    public static short readSwappedShort(byte[] byArray, int n2) {
        return (short)(((0xFF & byArray[n2 + 0]) << 0) + ((0xFF & byArray[n2 + 1]) << 8));
    }

    public static long readSwappedUnsignedInteger(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        long l2 = ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16);
        return ((long)(n5 & 0xFF) << 24) + (0xFFFFFFFFL & l2);
    }

    public static long readSwappedUnsignedInteger(byte[] byArray, int n2) {
        long l2 = ((0xFF & byArray[n2 + 0]) << 0) + ((0xFF & byArray[n2 + 1]) << 8) + ((0xFF & byArray[n2 + 2]) << 16);
        return ((long)(0xFF & byArray[n2 + 3]) << 24) + (0xFFFFFFFFL & l2);
    }

    public static int readSwappedUnsignedShort(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8);
    }

    public static int readSwappedUnsignedShort(byte[] byArray, int n2) {
        return ((0xFF & byArray[n2 + 0]) << 0) + ((0xFF & byArray[n2 + 1]) << 8);
    }

    public static double swapDouble(double d2) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(d2)));
    }

    public static float swapFloat(float f2) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(f2)));
    }

    public static int swapInteger(int n2) {
        return ((0xFF & n2 >> 0) << 24) + ((0xFF & n2 >> 8) << 16) + ((0xFF & n2 >> 16) << 8) + ((0xFF & n2 >> 24) << 0);
    }

    public static long swapLong(long l2) {
        return ((0xFFL & l2 >> 0) << 56) + ((0xFFL & l2 >> 8) << 48) + ((0xFFL & l2 >> 16) << 40) + ((0xFFL & l2 >> 24) << 32) + ((0xFFL & l2 >> 32) << 24) + ((0xFFL & l2 >> 40) << 16) + ((0xFFL & l2 >> 48) << 8) + ((0xFFL & l2 >> 56) << 0);
    }

    public static short swapShort(short s2) {
        return (short)(((0xFF & s2 >> 0) << 8) + ((0xFF & s2 >> 8) << 0));
    }

    public static void writeSwappedDouble(OutputStream outputStream, double d2) throws IOException {
        EndianUtils.writeSwappedLong(outputStream, Double.doubleToLongBits(d2));
    }

    public static void writeSwappedDouble(byte[] byArray, int n2, double d2) {
        EndianUtils.writeSwappedLong(byArray, n2, Double.doubleToLongBits(d2));
    }

    public static void writeSwappedFloat(OutputStream outputStream, float f2) throws IOException {
        EndianUtils.writeSwappedInteger(outputStream, Float.floatToIntBits(f2));
    }

    public static void writeSwappedFloat(byte[] byArray, int n2, float f2) {
        EndianUtils.writeSwappedInteger(byArray, n2, Float.floatToIntBits(f2));
    }

    public static void writeSwappedInteger(OutputStream outputStream, int n2) throws IOException {
        outputStream.write((byte)(0xFF & n2 >> 0));
        outputStream.write((byte)(0xFF & n2 >> 8));
        outputStream.write((byte)(0xFF & n2 >> 16));
        outputStream.write((byte)(0xFF & n2 >> 24));
    }

    public static void writeSwappedInteger(byte[] byArray, int n2, int n3) {
        byArray[n2 + 0] = (byte)(0xFF & n3 >> 0);
        byArray[n2 + 1] = (byte)(0xFF & n3 >> 8);
        byArray[n2 + 2] = (byte)(0xFF & n3 >> 16);
        byArray[n2 + 3] = (byte)(0xFF & n3 >> 24);
    }

    public static void writeSwappedLong(OutputStream outputStream, long l2) throws IOException {
        outputStream.write((byte)(0xFFL & l2 >> 0));
        outputStream.write((byte)(0xFFL & l2 >> 8));
        outputStream.write((byte)(0xFFL & l2 >> 16));
        outputStream.write((byte)(0xFFL & l2 >> 24));
        outputStream.write((byte)(0xFFL & l2 >> 32));
        outputStream.write((byte)(0xFFL & l2 >> 40));
        outputStream.write((byte)(0xFFL & l2 >> 48));
        outputStream.write((byte)(0xFFL & l2 >> 56));
    }

    public static void writeSwappedLong(byte[] byArray, int n2, long l2) {
        byArray[n2 + 0] = (byte)(0xFFL & l2 >> 0);
        byArray[n2 + 1] = (byte)(0xFFL & l2 >> 8);
        byArray[n2 + 2] = (byte)(0xFFL & l2 >> 16);
        byArray[n2 + 3] = (byte)(0xFFL & l2 >> 24);
        byArray[n2 + 4] = (byte)(0xFFL & l2 >> 32);
        byArray[n2 + 5] = (byte)(0xFFL & l2 >> 40);
        byArray[n2 + 6] = (byte)(0xFFL & l2 >> 48);
        byArray[n2 + 7] = (byte)(0xFFL & l2 >> 56);
    }

    public static void writeSwappedShort(OutputStream outputStream, short s2) throws IOException {
        outputStream.write((byte)(0xFF & s2 >> 0));
        outputStream.write((byte)(0xFF & s2 >> 8));
    }

    public static void writeSwappedShort(byte[] byArray, int n2, short s2) {
        byArray[n2 + 0] = (byte)(0xFF & s2 >> 0);
        byArray[n2 + 1] = (byte)(0xFF & s2 >> 8);
    }
}

