/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public abstract class DirectoryWalker {
    private final int depthLimit;
    private final FileFilter filter;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter fileFilter, int n2) {
        this.filter = fileFilter;
        this.depthLimit = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DirectoryWalker(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, int n2) {
        if (iOFileFilter == null && iOFileFilter2 == null) {
            this.filter = null;
        } else {
            if (iOFileFilter == null) {
                iOFileFilter = TrueFileFilter.TRUE;
            }
            if (iOFileFilter2 == null) {
                iOFileFilter2 = TrueFileFilter.TRUE;
            }
            this.filter = FileFilterUtils.orFileFilter(FileFilterUtils.makeDirectoryOnly(iOFileFilter), FileFilterUtils.makeFileOnly(iOFileFilter2));
        }
        this.depthLimit = n2;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private void walk(File file, int n2, Collection collection) throws IOException {
        this.checkIfCancelled(file, n2, collection);
        boolean bl2 = true;
        while (true) {
            int n3;
            File[] fileArray;
            int n4;
            block10: {
                block7: {
                    block8: {
                        block6: {
                            block9: {
                                if (!bl2 || (bl2 = false)) break block6;
                                if (!this.handleDirectory(file, n2, collection)) break block7;
                                this.handleDirectoryStart(file, n2, collection);
                                n4 = n2 + 1;
                                if (this.depthLimit >= 0 && n4 > this.depthLimit) break block8;
                                this.checkIfCancelled(file, n2, collection);
                                fileArray = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                                if (fileArray != null) break block9;
                                this.handleRestricted(file, n4, collection);
                                break block8;
                            }
                            n3 = 0;
                        }
                        if (n3 < fileArray.length) break block10;
                    }
                    this.handleDirectoryEnd(file, n2, collection);
                }
                this.checkIfCancelled(file, n2, collection);
                return;
            }
            File file2 = fileArray[n3];
            if (file2.isDirectory()) {
                this.walk(file2, n4, collection);
            } else {
                this.checkIfCancelled(file2, n4, collection);
                this.handleFile(file2, n4, collection);
                this.checkIfCancelled(file2, n4, collection);
            }
            ++n3;
        }
    }

    protected final void checkIfCancelled(File file, int n2, Collection collection) throws IOException {
        if (this.handleIsCancelled(file, n2, collection)) {
            throw new CancelException(file, n2);
        }
    }

    protected void handleCancelled(File file, Collection collection, CancelException cancelException) throws IOException {
        throw cancelException;
    }

    protected boolean handleDirectory(File file, int n2, Collection collection) throws IOException {
        return true;
    }

    protected void handleDirectoryEnd(File file, int n2, Collection collection) throws IOException {
    }

    protected void handleDirectoryStart(File file, int n2, Collection collection) throws IOException {
    }

    protected void handleEnd(Collection collection) throws IOException {
    }

    protected void handleFile(File file, int n2, Collection collection) throws IOException {
    }

    protected boolean handleIsCancelled(File file, int n2, Collection collection) throws IOException {
        return false;
    }

    protected void handleRestricted(File file, int n2, Collection collection) throws IOException {
    }

    protected void handleStart(File file, Collection collection) throws IOException {
    }

    protected final void walk(File file, Collection collection) throws IOException {
        if (file == null) {
            throw new NullPointerException("Start Directory is null");
        }
        try {
            this.handleStart(file, collection);
            this.walk(file, 0, collection);
            this.handleEnd(collection);
            return;
        }
        catch (CancelException cancelException) {
            this.handleCancelled(file, collection, cancelException);
            return;
        }
    }

    public static class CancelException
    extends IOException {
        private static final long serialVersionUID = 1347339620135041008L;
        private int depth = -1;
        private File file;

        public CancelException(File file, int n2) {
            this("Operation Cancelled", file, n2);
        }

        public CancelException(String string2, File file, int n2) {
            super(string2);
            this.file = file;
            this.depth = n2;
        }

        public int getDepth() {
            return this.depth;
        }

        public File getFile() {
            return this.file;
        }
    }
}

