/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class CopyUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        int n3 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        int n3 = 0;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        CopyUtils.copy((Reader)new InputStreamReader(inputStream), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string2) throws IOException {
        CopyUtils.copy((Reader)new InputStreamReader(inputStream, string2), writer);
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        CopyUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(String string2, OutputStream outputStream) throws IOException {
        StringReader stringReader = new StringReader(string2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        CopyUtils.copy((Reader)stringReader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(String string2, Writer writer) throws IOException {
        writer.write(string2);
    }

    public static void copy(byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(byArray);
    }

    public static void copy(byte[] byArray, Writer writer) throws IOException {
        CopyUtils.copy((InputStream)new ByteArrayInputStream(byArray), writer);
    }

    public static void copy(byte[] byArray, Writer writer, String string2) throws IOException {
        CopyUtils.copy(new ByteArrayInputStream(byArray), writer, string2);
    }
}

