/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.SparseArray;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.acra.ACRA;

public final class ReportUtils {
    public static String getApplicationFilePath(Context context) {
        File file = context.getFilesDir();
        if (file != null) {
            return file.getAbsolutePath();
        }
        Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve ApplicationFilePath for : " + context.getPackageName()));
        return "Couldn't retrieve ApplicationFilePath";
    }

    public static long getAvailableInternalMemorySize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getAvailableBlocks();
    }

    public static String getDeviceId(Context context) {
        try {
            String string2 = ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
            return string2;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve DeviceId for : " + context.getPackageName()), (Throwable)runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIpAddress() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (!bl2) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(inetAddress.getHostAddress().toString());
                    bl2 = false;
                }
            }
            return stringBuilder.toString();
        }
        catch (SocketException socketException) {
            ACRA.log.w(ACRA.LOG_TAG, socketException.toString());
        }
        return stringBuilder.toString();
    }

    public static long getTotalInternalMemorySize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getBlockCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String sparseArrayToString(SparseArray<?> sparseArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sparseArray == null) {
            return "null";
        }
        stringBuilder.append('{');
        int n2 = 0;
        while (true) {
            if (n2 >= sparseArray.size()) {
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
            stringBuilder.append(sparseArray.keyAt(n2));
            stringBuilder.append(" => ");
            if (sparseArray.valueAt(n2) == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(sparseArray.valueAt(n2).toString());
            }
            if (n2 < -1 + sparseArray.size()) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
    }
}

