/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import org.acra.ACRA;

public final class PackageManagerWrapper {
    private final Context context;

    public PackageManagerWrapper(Context context) {
        this.context = context;
    }

    public PackageInfo getPackageInfo() {
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.context.getPackageName(), 0);
            return packageInfo;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.v((String)ACRA.LOG_TAG, (String)("Failed to find PackageInfo for current App : " + this.context.getPackageName()));
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPermission(String string2) {
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager == null) return false;
        try {
            int n2 = packageManager.checkPermission(string2, this.context.getPackageName());
            if (n2 != 0) return false;
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

