/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONReportBuilder {
    private static void addJSONFromProperty(JSONObject jSONObject, String string2) throws JSONException {
        int n2 = string2.indexOf(61);
        if (n2 > 0) {
            String[] stringArray;
            String string3 = string2.substring(0, n2).trim();
            Object object = JSONReportBuilder.guessType(string2.substring(n2 + 1).trim());
            if (object instanceof String) {
                object = ((String)object).replaceAll("\\\\n", "\n");
            }
            if ((stringArray = string3.split("\\.")).length > 1) {
                JSONReportBuilder.addJSONSubTree(jSONObject, stringArray, object);
                return;
            }
            jSONObject.accumulate(string3, object);
            return;
        }
        jSONObject.put(string2.trim(), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addJSONSubTree(JSONObject jSONObject, String[] stringArray, Object object) throws JSONException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (n2 < -1 + stringArray.length) {
                JSONObject jSONObject2;
                if (jSONObject.isNull(string2)) {
                    jSONObject2 = new JSONObject();
                    jSONObject.accumulate(string2, (Object)jSONObject2);
                } else {
                    jSONObject2 = jSONObject.getJSONObject(string2);
                }
                jSONObject = jSONObject2;
            } else {
                jSONObject.accumulate(string2, object);
            }
            ++n2;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject buildJSONReport(CrashReportData crashReportData) throws JSONReportException {
        JSONObject jSONObject = new JSONObject();
        Iterator iterator = crashReportData.keySet().iterator();
        while (iterator.hasNext()) {
            ReportField reportField = (ReportField)((Object)iterator.next());
            try {
                if (reportField.containsKeyValuePairs()) {
                    JSONObject jSONObject2 = new JSONObject();
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(crashReportData.getProperty(reportField)), 1024);
                    try {
                        String string2;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            JSONReportBuilder.addJSONFromProperty(jSONObject2, string2);
                        }
                    }
                    catch (IOException iOException) {
                        ACRA.log.e(ACRA.LOG_TAG, "Error while converting " + reportField.name() + " to JSON.", iOException);
                    }
                    jSONObject.accumulate(reportField.name(), (Object)jSONObject2);
                    continue;
                }
            }
            catch (JSONException jSONException) {
                throw new JSONReportException("Could not create JSON object for key " + (Object)((Object)reportField), jSONException);
            }
            {
                jSONObject.accumulate(reportField.name(), JSONReportBuilder.guessType(crashReportData.getProperty(reportField)));
                continue;
            }
            break;
        }
        return jSONObject;
    }

    private static Object guessType(String string2) {
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.matches("(?:^|\\s)([1-9](?:\\d*|(?:\\d{0,2})(?:,\\d{3})*)(?:\\.\\d*[1-9])?|0?\\.\\d*[1-9]|0)(?:\\s|$)")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            try {
                Number number = numberFormat.parse(string2);
                return number;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static class JSONReportException
    extends Exception {
        private static final long serialVersionUID = -694684023635442219L;

        public JSONReportException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

