/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;
import org.acra.ACRA;

public class Installation {
    private static final String INSTALLATION = "ACRA-INSTALLATION";
    private static String sID;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String id(Context context) {
        synchronized (Installation.class) {
            if (sID != null) return sID;
            File file = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!file.exists()) {
                    Installation.writeInstallationFile(file);
                }
                sID = Installation.readInstallationFile(file);
                return sID;
            }
            catch (IOException iOException) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)iOException);
                return "Couldn't retrieve InstallationId";
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)runtimeException);
                return "Couldn't retrieve InstallationId";
            }
        }
    }

    private static String readInstallationFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        try {
            randomAccessFile.readFully(byArray);
            return new String(byArray);
        }
        finally {
            randomAccessFile.close();
        }
    }

    private static void writeInstallationFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(UUID.randomUUID().toString().getBytes());
            return;
        }
        finally {
            fileOutputStream.close();
        }
    }
}

