/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.acra.ACRA;
import org.acra.sender.HttpSender;
import org.acra.util.FakeSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class HttpRequest {
    private int connectionTimeOut = 3000;
    private Map<String, String> headers;
    private String login;
    private int maxNrRetries = 3;
    private String password;
    private int socketTimeOut = 3000;

    private UsernamePasswordCredentials getCredentials() {
        if (this.login != null || this.password != null) {
            return new UsernamePasswordCredentials(this.login, this.password);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpClient getHttpClient() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)this.connectionTimeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)this.socketTimeOut);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80));
        if (ACRA.getConfig().disableSSLCertValidation()) {
            schemeRegistry.register(new Scheme("https", (SocketFactory)new FakeSocketFactory(), 443));
        } else {
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry), (HttpParams)basicHttpParams);
        defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new SocketTimeOutRetryHandler((HttpParams)basicHttpParams, this.maxNrRetries));
        return defaultHttpClient;
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpEntityEnclosingRequestBase getHttpRequest(URL uRL, HttpSender.Method method, String string2, HttpSender.Type type) throws UnsupportedEncodingException, UnsupportedOperationException {
        UsernamePasswordCredentials usernamePasswordCredentials;
        HttpPost httpPost;
        switch (1.$SwitchMap$org$acra$sender$HttpSender$Method[method.ordinal()]) {
            default: {
                throw new UnsupportedOperationException("Unknown method: " + method.name());
            }
            case 1: {
                httpPost = new HttpPost(uRL.toString());
                break;
            }
            case 2: {
                httpPost = new HttpPut(uRL.toString());
            }
        }
        if ((usernamePasswordCredentials = this.getCredentials()) != null) {
            httpPost.addHeader(BasicScheme.authenticate((Credentials)usernamePasswordCredentials, (String)"UTF-8", (boolean)false));
        }
        httpPost.setHeader("User-Agent", "Android");
        httpPost.setHeader("Accept", "text/html,application/xml,application/json,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        httpPost.setHeader("Content-Type", type.getContentType());
        if (this.headers != null) {
            for (String string3 : this.headers.keySet()) {
                httpPost.setHeader(string3, this.headers.get(string3));
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
        return httpPost;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getParamsAsFormString(Map<?, ?> map) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object obj;
            Object obj2 = iterator.next();
            if (stringBuilder.length() != 0) {
                stringBuilder.append('&');
            }
            String string2 = (obj = map.get(obj2)) == null ? "" : obj;
            stringBuilder.append(URLEncoder.encode(obj2.toString(), "UTF-8"));
            stringBuilder.append('=');
            stringBuilder.append(URLEncoder.encode(string2.toString(), "UTF-8"));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(URL uRL, HttpSender.Method method, String string2, HttpSender.Type type) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = this.getHttpRequest(uRL, method, string2, type);
        ACRA.log.d(ACRA.LOG_TAG, "Sending request to " + uRL);
        HttpResponse httpResponse = null;
        try {
            String string3;
            httpResponse = httpClient.execute((HttpUriRequest)httpEntityEnclosingRequestBase, (HttpContext)new BasicHttpContext());
            if (httpResponse == null) return;
            if (httpResponse.getStatusLine() != null && !(string3 = Integer.toString(httpResponse.getStatusLine().getStatusCode())).equals("409") && !string3.equals("403")) {
                if (string3.startsWith("4")) throw new IOException("Host returned error code " + string3);
                if (string3.startsWith("5")) {
                    throw new IOException("Host returned error code " + string3);
                }
            }
            EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            return;
        }
        finally {
            if (httpResponse != null) {
                httpResponse.getEntity().consumeContent();
            }
        }
    }

    public void setConnectionTimeOut(int n2) {
        this.connectionTimeOut = n2;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    public void setLogin(String string2) {
        this.login = string2;
    }

    public void setMaxNrRetries(int n2) {
        this.maxNrRetries = n2;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setSocketTimeOut(int n2) {
        this.socketTimeOut = n2;
    }

    private static class SocketTimeOutRetryHandler
    implements HttpRequestRetryHandler {
        private final HttpParams httpParams;
        private final int maxNrRetries;

        private SocketTimeOutRetryHandler(HttpParams httpParams, int n2) {
            this.httpParams = httpParams;
            this.maxNrRetries = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean retryRequest(IOException iOException, int n2, HttpContext httpContext) {
            if (!(iOException instanceof SocketTimeoutException)) return false;
            if (n2 <= this.maxNrRetries) {
                if (this.httpParams != null) {
                    int n3 = 2 * HttpConnectionParams.getSoTimeout((HttpParams)this.httpParams);
                    HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)n3);
                    ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - increasing time out to " + n3 + " millis and trying again");
                    return true;
                }
                ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut - no HttpParams, cannot increase time out. Trying again with current settings");
                return true;
            }
            ACRA.log.d(ACRA.LOG_TAG, "SocketTimeOut but exceeded max number of retries : " + this.maxNrRetries);
            return false;
        }
    }
}

