/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.acra.util.NaiveTrustManager;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class FakeSocketFactory
implements SocketFactory,
LayeredSocketFactory {
    private SSLContext sslcontext = null;

    private static SSLContext createEasySSLContext() throws IOException {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{new NaiveTrustManager()};
            sSLContext.init(null, trustManagerArray, null);
            return sSLContext;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private SSLContext getSSLContext() throws IOException {
        if (this.sslcontext == null) {
            this.sslcontext = FakeSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Socket connectSocket(Socket socket, String string2, int n2, InetAddress inetAddress, int n3, HttpParams httpParams) throws IOException {
        int n4 = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
        int n5 = HttpConnectionParams.getSoTimeout((HttpParams)httpParams);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string2, n2);
        Socket socket2 = socket != null ? socket : this.createSocket();
        SSLSocket sSLSocket = (SSLSocket)socket2;
        if (inetAddress != null || n3 > 0) {
            if (n3 < 0) {
                n3 = 0;
            }
            sSLSocket.bind(new InetSocketAddress(inetAddress, n3));
        }
        sSLSocket.connect(inetSocketAddress, n4);
        sSLSocket.setSoTimeout(n5);
        return sSLSocket;
    }

    public Socket createSocket() throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket();
    }

    public Socket createSocket(Socket socket, String string2, int n2, boolean bl2) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string2, n2, bl2);
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return true;
    }
}

