/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.HttpRequest;
import org.acra.util.JSONReportBuilder;

public class HttpSender
implements ReportSender {
    private final Uri mFormUri;
    private final Map<ReportField, String> mMapping;
    private final Method mMethod;
    private final Type mType;

    public HttpSender(Method method, Type type, String string2, Map<ReportField, String> map) {
        this.mMethod = method;
        this.mFormUri = Uri.parse((String)string2);
        this.mMapping = map;
        this.mType = type;
    }

    public HttpSender(Method method, Type type, Map<ReportField, String> map) {
        this.mMethod = method;
        this.mFormUri = null;
        this.mMapping = map;
        this.mType = type;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, String> remap(Map<ReportField, String> map) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        ReportField[] reportFieldArray2 = reportFieldArray;
        int n2 = reportFieldArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            ReportField reportField = reportFieldArray2[n3];
            if (this.mMapping == null || this.mMapping.get((Object)reportField) == null) {
                hashMap.put(reportField.toString(), map.get((Object)reportField));
            } else {
                hashMap.put(this.mMapping.get((Object)reportField), map.get((Object)reportField));
            }
            ++n3;
        }
        return hashMap;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        try {
            String string2;
            URL uRL = this.mFormUri == null ? new URL(ACRA.getConfig().formUri()) : new URL(this.mFormUri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + uRL.toString()));
            String string3 = ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthLogin()) ? null : ACRA.getConfig().formUriBasicAuthLogin();
            boolean bl2 = ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthPassword());
            String string4 = null;
            if (!bl2) {
                string4 = ACRA.getConfig().formUriBasicAuthPassword();
            }
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            httpRequest.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            httpRequest.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            httpRequest.setLogin(string3);
            httpRequest.setPassword(string4);
            httpRequest.setHeaders(ACRA.getConfig().getHttpHeaders());
            switch (this.mType) {
                default: {
                    string2 = HttpRequest.getParamsAsFormString(this.remap(crashReportData));
                    break;
                }
                case JSON: {
                    string2 = crashReportData.toJSON().toString();
                }
            }
            switch (this.mMethod) {
                default: {
                    throw new UnsupportedOperationException("Unknown method: " + this.mMethod.name());
                }
                case PUT: {
                    uRL = new URL(uRL.toString() + '/' + crashReportData.getProperty(ReportField.REPORT_ID));
                    break;
                }
                case POST: 
            }
            httpRequest.send(uRL, this.mMethod, string2, this.mType);
            return;
        }
        catch (IOException iOException) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), iOException);
        }
        catch (JSONReportBuilder.JSONReportException jSONReportException) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), jSONReportException);
        }
    }

    public static final class Method
    extends Enum<Method> {
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method POST = new Method();
        public static final /* enum */ Method PUT = new Method();

        static {
            Method[] methodArray = new Method[]{POST, PUT};
            $VALUES = methodArray;
        }

        public static Method valueOf(String string2) {
            return Enum.valueOf(Method.class, string2);
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }
    }

    public static abstract class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type FORM = new Type(){

            @Override
            public String getContentType() {
                return "application/x-www-form-urlencoded";
            }
        };
        public static final /* enum */ Type JSON = new Type(){

            @Override
            public String getContentType() {
                return "application/json";
            }
        };

        static {
            Type[] typeArray = new Type[]{FORM, JSON};
            $VALUES = typeArray;
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public abstract String getContentType();
    }
}

