/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.sender.HttpSender;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.HttpRequest;

public class GoogleFormSender
implements ReportSender {
    private final Uri mFormUri;

    public GoogleFormSender() {
        this.mFormUri = null;
    }

    public GoogleFormSender(String string2) {
        this.mFormUri = Uri.parse((String)String.format(ACRA.getConfig().googleFormUrlFormat(), string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, String> remap(Map<ReportField, String> map) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        int n2 = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportField[] reportFieldArray2 = reportFieldArray;
        int n3 = reportFieldArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ReportField reportField = reportFieldArray2[n4];
            switch (1.$SwitchMap$org$acra$ReportField[reportField.ordinal()]) {
                default: {
                    hashMap.put("entry." + n2 + ".single", map.get((Object)reportField));
                    break;
                }
                case 1: {
                    hashMap.put("entry." + n2 + ".single", "'" + map.get((Object)reportField));
                    break;
                }
                case 2: {
                    hashMap.put("entry." + n2 + ".single", "'" + map.get((Object)reportField));
                }
            }
            ++n2;
            ++n4;
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        Uri uri;
        if (this.mFormUri == null) {
            String string2 = ACRA.getConfig().googleFormUrlFormat();
            Object[] objectArray = new Object[]{ACRA.getConfig().formKey()};
            uri = Uri.parse((String)String.format(string2, objectArray));
        } else {
            uri = this.mFormUri;
        }
        Map<String, String> map = this.remap(crashReportData);
        map.put("pageNumber", "0");
        map.put("backupCache", "");
        map.put("submit", "Envoyer");
        try {
            URL uRL = new URL(uri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Sending report " + (String)crashReportData.get((Object)ReportField.REPORT_ID)));
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + uRL));
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            httpRequest.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            httpRequest.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            httpRequest.send(uRL, HttpSender.Method.POST, HttpRequest.getParamsAsFormString(map), HttpSender.Type.FORM);
            return;
        }
        catch (IOException iOException) {
            throw new ReportSenderException("Error while sending report to Google Form.", iOException);
        }
    }
}

