/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.content.Intent;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;

public class EmailIntentSender
implements ReportSender {
    private final Context mContext;

    public EmailIntentSender(Context context) {
        this.mContext = context;
    }

    private String buildBody(CrashReportData crashReportData) {
        ReportField[] reportFieldArray = ACRA.getConfig().customReportContent();
        if (reportFieldArray.length == 0) {
            reportFieldArray = ACRAConstants.DEFAULT_MAIL_REPORT_FIELDS;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ReportField reportField : reportFieldArray) {
            stringBuilder.append(reportField.toString()).append("=");
            stringBuilder.append((String)crashReportData.get((Object)reportField));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void send(CrashReportData crashReportData) throws ReportSenderException {
        String string2 = this.mContext.getPackageName() + " Crash Report";
        String string3 = this.buildBody(crashReportData);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.addFlags(0x10000000);
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", string2);
        intent.putExtra("android.intent.extra.TEXT", string3);
        String[] stringArray = new String[]{ACRA.getConfig().mailTo()};
        intent.putExtra("android.intent.extra.EMAIL", stringArray);
        this.mContext.startActivity(intent);
    }
}

