/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class SettingsCollector {
    SettingsCollector() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String collectGlobalSettings(Context context) {
        int n2;
        Method method;
        Field[] fieldArray;
        if (Compatibility.getAPILevel() < 17) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Class<?> clazz = Class.forName("android.provider.Settings$Global");
            fieldArray = clazz.getFields();
            method = clazz.getMethod("getString", ContentResolver.class, String.class);
            n2 = fieldArray.length;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
            return stringBuilder.toString();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)classNotFoundException);
            return stringBuilder.toString();
        }
        catch (SecurityException securityException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)securityException);
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)noSuchMethodException);
            return stringBuilder.toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)invocationTargetException);
            return stringBuilder.toString();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray;
            Object object;
            Field field = fieldArray[i2];
            if (field.isAnnotationPresent(Deprecated.class) || field.getType() != String.class || !SettingsCollector.isAuthorized(field) || (object = method.invoke(null, objectArray = new Object[]{context.getContentResolver(), (String)field.get(null)})) == null) continue;
            try {
                stringBuilder.append(field.getName()).append("=").append(object).append("\n");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
                return stringBuilder.toString();
            }
            continue;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectSecureSettings(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = Settings.Secure.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (!field.isAnnotationPresent(Deprecated.class) && field.getType() == String.class && SettingsCollector.isAuthorized(field)) {
                try {
                    String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)((String)field.get(null)));
                    if (string2 != null) {
                        stringBuilder.append(field.getName()).append("=").append((Object)string2).append("\n");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
                }
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectSystemSettings(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = Settings.System.class.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (!field.isAnnotationPresent(Deprecated.class) && field.getType() == String.class) {
                try {
                    String string2 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)((String)field.get(null)));
                    if (string2 != null) {
                        stringBuilder.append(field.getName()).append("=").append((Object)string2).append("\n");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)illegalAccessException);
                }
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isAuthorized(Field field) {
        if (field != null && !field.getName().startsWith("WIFI_AP")) {
            String[] stringArray = ACRA.getConfig().excludeMatchingSettingsKeys();
            int n2 = stringArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                String string2 = stringArray[n3];
                if (field.getName().matches(string2)) break;
                ++n3;
            }
        }
        return false;
    }
}

