/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class ReflectionCollector {
    ReflectionCollector() {
    }

    public static String collectConstants(Class<?> clazz) {
        return ReflectionCollector.collectConstants(clazz, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectConstants(Class<?> clazz, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = clazz.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append(string2).append('.');
            }
            stringBuilder.append(field.getName()).append("=");
            try {
                stringBuilder.append(field.get(null).toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringBuilder.append("N/A");
            }
            catch (IllegalAccessException illegalAccessException) {
                stringBuilder.append("N/A");
            }
            stringBuilder.append("\n");
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectStaticGettersResults(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Method[] methodArray = clazz.getMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            if (method.getParameterTypes().length == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is")) && !method.getName().equals("getClass")) {
                try {
                    stringBuilder.append(method.getName());
                    stringBuilder.append('=');
                    stringBuilder.append(method.invoke(null, (Object[])null));
                    stringBuilder.append("\n");
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n3;
        }
        return stringBuilder.toString();
    }
}

