/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MediaCodecListCollector {
    private static final String[] AAC_TYPES;
    private static final String[] AVC_TYPES;
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] H263_TYPES;
    private static final String[] MPEG4_TYPES;
    private static Class<?> codecCapabilitiesClass;
    private static Field colorFormatsField;
    private static Method getCapabilitiesForTypeMethod;
    private static Method getCodecInfoAtMethod;
    private static Method getNameMethod;
    private static Method getSupportedTypesMethod;
    private static Method isEncoderMethod;
    private static Field levelField;
    private static SparseArray<String> mAACProfileValues;
    private static SparseArray<String> mAVCLevelValues;
    private static SparseArray<String> mAVCProfileValues;
    private static SparseArray<String> mColorFormatValues;
    private static SparseArray<String> mH263LevelValues;
    private static SparseArray<String> mH263ProfileValues;
    private static SparseArray<String> mMPEG4LevelValues;
    private static SparseArray<String> mMPEG4ProfileValues;
    private static Class<?> mediaCodecInfoClass;
    private static Class<?> mediaCodecListClass;
    private static Field profileField;
    private static Field profileLevelsField;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        int n2;
        int n3;
        Field[] fieldArray;
        Class<?> clazz;
        MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
        AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
        H263_TYPES = new String[]{"h263", "H263"};
        AAC_TYPES = new String[]{"aac", "AAC"};
        mediaCodecListClass = null;
        getCodecInfoAtMethod = null;
        mediaCodecInfoClass = null;
        getNameMethod = null;
        isEncoderMethod = null;
        getSupportedTypesMethod = null;
        getCapabilitiesForTypeMethod = null;
        codecCapabilitiesClass = null;
        colorFormatsField = null;
        profileLevelsField = null;
        profileField = null;
        levelField = null;
        mColorFormatValues = new SparseArray();
        mAVCLevelValues = new SparseArray();
        mAVCProfileValues = new SparseArray();
        mH263LevelValues = new SparseArray();
        mH263ProfileValues = new SparseArray();
        mMPEG4LevelValues = new SparseArray();
        mMPEG4ProfileValues = new SparseArray();
        mAACProfileValues = new SparseArray();
        try {
            mediaCodecListClass = Class.forName("android.media.MediaCodecList");
            Class<?> clazz2 = mediaCodecListClass;
            Class[] classArray = new Class[]{Integer.TYPE};
            getCodecInfoAtMethod = clazz2.getMethod("getCodecInfoAt", classArray);
            mediaCodecInfoClass = Class.forName("android.media.MediaCodecInfo");
            getNameMethod = mediaCodecInfoClass.getMethod("getName", new Class[0]);
            isEncoderMethod = mediaCodecInfoClass.getMethod("isEncoder", new Class[0]);
            getSupportedTypesMethod = mediaCodecInfoClass.getMethod("getSupportedTypes", new Class[0]);
            getCapabilitiesForTypeMethod = mediaCodecInfoClass.getMethod("getCapabilitiesForType", String.class);
            codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            colorFormatsField = codecCapabilitiesClass.getField("colorFormats");
            profileLevelsField = codecCapabilitiesClass.getField("profileLevels");
            Field[] fieldArray2 = codecCapabilitiesClass.getFields();
            int n4 = fieldArray2.length;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    clazz = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
                    fieldArray = clazz.getFields();
                    n3 = fieldArray.length;
                    n2 = 0;
                    break;
                }
                Field field = fieldArray2[n5];
                if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().startsWith(COLOR_FORMAT_PREFIX)) {
                    mColorFormatValues.put(field.getInt(null), (Object)field.getName());
                }
                ++n5;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        while (true) {
            if (n2 >= n3) {
                profileField = clazz.getField("profile");
                levelField = clazz.getField("level");
                return;
            }
            Field field = fieldArray[n2];
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                if (field.getName().startsWith("AVCLevel")) {
                    mAVCLevelValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("AVCProfile")) {
                    mAVCProfileValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("H263Level")) {
                    mH263LevelValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("H263Profile")) {
                    mH263ProfileValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("MPEG4Level")) {
                    mMPEG4LevelValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("MPEG4Profile")) {
                    mMPEG4ProfileValues.put(field.getInt(null), (Object)field.getName());
                } else if (field.getName().startsWith("AAC")) {
                    mAACProfileValues.put(field.getInt(null), (Object)field.getName());
                }
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String collecMediaCodecList() {
        StringBuilder stringBuilder = new StringBuilder();
        if (mediaCodecListClass != null && mediaCodecInfoClass != null) {
            int n2 = (Integer)mediaCodecListClass.getMethod("getCodecCount", new Class[0]).invoke(null, new Object[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("\n");
                Method method = getCodecInfoAtMethod;
                Object[] objectArray = new Object[]{i2};
                Object object = method.invoke(null, objectArray);
                stringBuilder.append(i2).append(": ").append(getNameMethod.invoke(object, new Object[0])).append("\n");
                stringBuilder.append("isEncoder: ").append(isEncoderMethod.invoke(object, new Object[0])).append("\n");
                Object[] objectArray2 = (String[])getSupportedTypesMethod.invoke(object, new Object[0]);
                stringBuilder.append("Supported types: ").append(Arrays.toString(objectArray2)).append("\n");
                int n3 = objectArray2.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    stringBuilder.append(MediaCodecListCollector.collectCapabilitiesForType(object, (String)objectArray2[i3]));
                    continue;
                }
                try {
                    stringBuilder.append("\n");
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                    return stringBuilder.toString();
                }
            }
        }
        return stringBuilder.toString();
        catch (IllegalAccessException illegalAccessException) {
            return stringBuilder.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return stringBuilder.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String collectCapabilitiesForType(Object object, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = getCapabilitiesForTypeMethod.invoke(object, string2);
        int[] nArray = (int[])colorFormatsField.get(object2);
        if (nArray.length > 0) {
            stringBuilder.append(string2).append(" color formats:");
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                stringBuilder.append((String)mColorFormatValues.get(nArray[i2]));
                if (i2 >= -1 + nArray.length) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append("\n");
        }
        if ((objectArray = (Object[])profileLevelsField.get(object2)).length > 0) {
            stringBuilder.append(string2).append(" profile levels:");
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                CodecType codecType = MediaCodecListCollector.identifyCodecType(object);
                int n2 = profileField.getInt(objectArray[i3]);
                int n3 = levelField.getInt(objectArray[i3]);
                if (codecType == null) {
                    stringBuilder.append(n2).append('-').append(n3);
                }
                switch (1.$SwitchMap$org$acra$collector$MediaCodecListCollector$CodecType[codecType.ordinal()]) {
                    case 1: {
                        stringBuilder.append(n2).append((String)mAVCProfileValues.get(n2)).append('-').append((String)mAVCLevelValues.get(n3));
                        break;
                    }
                    case 2: {
                        stringBuilder.append((String)mH263ProfileValues.get(n2)).append('-').append((String)mH263LevelValues.get(n3));
                        break;
                    }
                    case 3: {
                        stringBuilder.append((String)mMPEG4ProfileValues.get(n2)).append('-').append((String)mMPEG4LevelValues.get(n3));
                        break;
                    }
                    case 4: {
                        stringBuilder.append((String)mAACProfileValues.get(n2));
                        break;
                    }
                }
                if (i3 >= -1 + objectArray.length) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.append("\n").toString();
    }

    private static CodecType identifyCodecType(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String string2 = (String)getNameMethod.invoke(object, new Object[0]);
        String[] stringArray = AVC_TYPES;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.contains(stringArray[i2])) continue;
            return CodecType.AVC;
        }
        String[] stringArray2 = H263_TYPES;
        int n3 = stringArray2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            if (!string2.contains(stringArray2[i3])) continue;
            return CodecType.H263;
        }
        String[] stringArray3 = MPEG4_TYPES;
        int n4 = stringArray3.length;
        for (int i4 = 0; i4 < n4; ++i4) {
            if (!string2.contains(stringArray3[i4])) continue;
            return CodecType.MPEG4;
        }
        String[] stringArray4 = AAC_TYPES;
        int n5 = stringArray4.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            if (!string2.contains(stringArray4[i5])) continue;
            return CodecType.AAC;
        }
        return null;
    }

    private static final class CodecType
    extends Enum<CodecType> {
        private static final /* synthetic */ CodecType[] $VALUES;
        public static final /* enum */ CodecType AAC;
        public static final /* enum */ CodecType AVC;
        public static final /* enum */ CodecType H263;
        public static final /* enum */ CodecType MPEG4;

        static {
            AVC = new CodecType();
            H263 = new CodecType();
            MPEG4 = new CodecType();
            AAC = new CodecType();
            CodecType[] codecTypeArray = new CodecType[]{AVC, H263, MPEG4, AAC};
            $VALUES = codecTypeArray;
        }

        public static CodecType valueOf(String string2) {
            return Enum.valueOf(CodecType.class, string2);
        }

        public static CodecType[] values() {
            return (CodecType[])$VALUES.clone();
        }
    }
}

